/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.oggdecoder;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import com.jcraft.oggdecoder.OggData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class OggDecoder {
    private int convsize = 8192;
    private byte[] convbuffer = new byte[this.convsize];

    public OggData getData(InputStream input) throws IOException {
        ByteArrayOutputStream dataout = new ByteArrayOutputStream();
        SyncState oy = new SyncState();
        StreamState os = new StreamState();
        Page og = new Page();
        Packet op = new Packet();
        Info vi = new Info();
        Comment vc = new Comment();
        DspState vd = new DspState();
        Block vb = new Block(vd);
        int bytes = 0;
        boolean bigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        oy.init();
        while (true) {
            boolean eos = false;
            int index = oy.buffer(4096);
            byte[] buffer = oy.data;
            try {
                bytes = input.read(buffer, index, 4096);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            oy.wrote(bytes);
            if (oy.pageout(og) != 1) {
                if (bytes < 4096) break;
                throw new IOException("Input does not appear to be an Ogg bitstream.");
            }
            os.init(og.serialno());
            vi.init();
            vc.init();
            if (os.pagein(og) < 0) {
                throw new IOException("Error reading first page of Ogg bitstream data.");
            }
            if (os.packetout(op) != 1) {
                throw new IOException("Error reading initial header packet.");
            }
            if (vi.synthesis_headerin(vc, op) < 0) {
                throw new IOException("This Ogg bitstream does not contain Vorbis audio data.");
            }
            int i = 0;
            while (i < 2) {
                int result;
                while (i < 2 && (result = oy.pageout(og)) != 0) {
                    if (result != 1) continue;
                    os.pagein(og);
                    while (i < 2 && (result = os.packetout(op)) != 0) {
                        if (result == -1) {
                            throw new IOException("Corrupt secondary header.  Exiting.");
                        }
                        vi.synthesis_headerin(vc, op);
                        ++i;
                    }
                }
                index = oy.buffer(4096);
                buffer = oy.data;
                try {
                    bytes = input.read(buffer, index, 4096);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
                if (bytes == 0 && i < 2) {
                    throw new IOException("End of file before finding all Vorbis headers!");
                }
                oy.wrote(bytes);
            }
            this.convsize = 4096 / vi.channels;
            vd.synthesis_init(vi);
            vb.init(vd);
            float[][][] _pcm = new float[1][][];
            int[] _index = new int[vi.channels];
            while (!eos) {
                int result;
                while (!eos && (result = oy.pageout(og)) != 0) {
                    if (result == -1) {
                        System.err.println("Corrupt or missing data in bitstream; continuing...");
                        continue;
                    }
                    os.pagein(og);
                    while ((result = os.packetout(op)) != 0) {
                        int samples;
                        if (result == -1) continue;
                        if (vb.synthesis(op) == 0) {
                            vd.synthesis_blockin(vb);
                        }
                        while ((samples = vd.synthesis_pcmout(_pcm, _index)) > 0) {
                            float[][] pcm = _pcm[0];
                            boolean clipflag = false;
                            int bout = samples < this.convsize ? samples : this.convsize;
                            for (i = 0; i < vi.channels; ++i) {
                                int ptr = i * 2;
                                int mono = _index[i];
                                for (int j = 0; j < bout; ++j) {
                                    int val = (int)((double)pcm[i][mono + j] * 32767.0);
                                    if (val > Short.MAX_VALUE) {
                                        val = Short.MAX_VALUE;
                                        clipflag = true;
                                    }
                                    if (val < Short.MIN_VALUE) {
                                        val = Short.MIN_VALUE;
                                        clipflag = true;
                                    }
                                    if (val < 0) {
                                        val |= 0x8000;
                                    }
                                    if (bigEndian) {
                                        this.convbuffer[ptr] = (byte)(val >>> 8);
                                        this.convbuffer[ptr + 1] = (byte)val;
                                    } else {
                                        this.convbuffer[ptr] = (byte)val;
                                        this.convbuffer[ptr + 1] = (byte)(val >>> 8);
                                    }
                                    ptr += 2 * vi.channels;
                                }
                            }
                            dataout.write(this.convbuffer, 0, 2 * vi.channels * bout);
                            vd.synthesis_read(bout);
                        }
                    }
                    if (og.eos() == 0) continue;
                    eos = true;
                }
                if (eos) continue;
                index = oy.buffer(4096);
                buffer = oy.data;
                try {
                    bytes = input.read(buffer, index, 4096);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
                oy.wrote(bytes);
                if (bytes != 0) continue;
                eos = true;
            }
            os.clear();
            vb.clear();
            vd.clear();
            vi.clear();
        }
        oy.clear();
        OggData ogg = new OggData();
        ogg.channels = vi.channels;
        ogg.rate = vi.rate;
        byte[] data = dataout.toByteArray();
        ogg.data = ByteBuffer.allocateDirect(data.length);
        ogg.data.put(data);
        ogg.data.rewind();
        return ogg;
    }
}

