/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export;

import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.ReadCSC;
import com.mycompany.csc_export.SM_AudioChunk;
import com.mycompany.csc_export.SM_MissionSound;
import com.mycompany.csc_export.SM_Offset;
import com.mycompany.csc_export.SM_SoundFileInfo;
import com.mycompany.csc_export.SM_SoundInfo;
import com.mycompany.csc_export.SM_SoundTagData;
import com.mycompany.csc_export.SM_Tag;
import com.mycompany.csc_export.SM_TaggedSound;
import com.mycompany.csc_export.WriteCSC;
import com.mycompany.csc_export.WriteXML;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CSC_SoundFile {
    private String path;
    private byte[] aUnknown;
    private SM_Tag[] tags;
    private SM_TaggedSound[] taggedSounds;
    private SM_MissionSound[] missionSounds;
    private SM_SoundInfo[] soundInfo;
    private SM_AudioChunk[] audioData;
    private int tagsLen;
    private int taggedSoundsLen;
    private int missionSoundsLen;
    private int soundInfoLen = 0;
    private int audioInfoLen = 0;
    private Map<SM_Offset, SM_SoundTagData> soundMap = new HashMap<SM_Offset, SM_SoundTagData>();
    private Map<SM_Offset, SM_SoundFileInfo> audioMap = new HashMap<SM_Offset, SM_SoundFileInfo>();
    private Map<SM_Offset, SM_AudioChunk> audioNameMap = new HashMap<SM_Offset, SM_AudioChunk>();
    private Map<String, SM_SoundTagData> missionSoundMap = new HashMap<String, SM_SoundTagData>();
    private boolean referenceFileLoaded = false;
    private boolean fileChanged = false;
    private Object[][] formData;
    private String[] tagSelectionData = null;
    private String[][] subTagSelectionData = null;
    private FileChannel[] chunkChannel = new FileChannel[6];
    private FileInputStream[] chunkFile = new FileInputStream[6];

    public CSC_SoundFile(String path, boolean full) throws IOException, MainClass.IllegalReadException, MainClass.FileStructureException {
        this.path = path;
        File aFile = new File(path);
        try {
            MainClass.inFile = new FileInputStream(aFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.err);
        }
        try {
            int i;
            int i2;
            MainClass.inChannel = MainClass.inFile.getChannel();
            ReadCSC.setCurrentFile(this);
            System.err.println(path);
            ByteBuffer headerBuf = ByteBuffer.allocate(13);
            if (MainClass.inChannel.read(headerBuf) == -1) {
                throw new MainClass.IllegalReadException();
            }
            headerBuf.flip();
            this.aUnknown = new byte[13];
            headerBuf.get(this.aUnknown);
            this.tagsLen = ReadCSC.readByte();
            this.tags = new SM_Tag[this.tagsLen];
            for (i2 = 0; i2 < this.tagsLen; ++i2) {
                try {
                    this.tags[i2] = new SM_Tag();
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Reading SM_Tag #" + i2);
                    throw e;
                }
            }
            this.taggedSoundsLen = ReadCSC.readInt();
            this.taggedSounds = new SM_TaggedSound[this.taggedSoundsLen];
            for (i2 = 0; i2 < this.taggedSoundsLen; ++i2) {
                try {
                    this.taggedSounds[i2] = new SM_TaggedSound();
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Reading SM_TaggedSound #" + i2);
                    throw e;
                }
            }
            this.missionSoundsLen = ReadCSC.readInt();
            this.missionSounds = new SM_MissionSound[this.missionSoundsLen];
            for (i2 = 0; i2 < this.missionSoundsLen; ++i2) {
                try {
                    this.missionSounds[i2] = new SM_MissionSound();
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Reading SM_MissionSound #" + i2);
                    throw e;
                }
            }
            this.soundInfo = new SM_SoundInfo[30000];
            int countBarrier = 5000;
            try {
                SM_SoundInfo subtitleChunk;
                while ((subtitleChunk = new SM_SoundInfo()).getNumFiles() >= 0) {
                    this.soundInfo[this.soundInfoLen++] = subtitleChunk;
                    if (this.soundInfoLen <= countBarrier) continue;
                    System.err.println("Processing subtitles: " + countBarrier + "...");
                    countBarrier += 5000;
                }
            }
            catch (Exception e) {
                System.err.println("Reading SoundInfo #" + this.soundInfoLen);
                throw e;
            }
            System.err.println("Processing subtitles: " + this.soundInfoLen + " Done!");
            this.audioData = new SM_AudioChunk[40000];
            int fileId = 2;
            Path pathDir = Paths.get(path, new String[0]).toAbsolutePath();
            String[] additionalFiles = new String[]{"", "", pathDir.getFileName().toString(), "SchemaMetafile_DVD1.csc", "SchemaMetafile_DVD2.csc", "SchemaMetafile_DVD3.csc"};
            countBarrier = 5000;
            while (true) {
                if (MainClass.inFile != null) {
                    try {
                        SM_AudioChunk audioChunk = new SM_AudioChunk(fileId);
                        this.audioData[this.audioInfoLen++] = audioChunk;
                        if (this.audioInfoLen > countBarrier) {
                            System.err.println("Processing audio, " + additionalFiles[fileId] + ": " + countBarrier + "...");
                            countBarrier += 5000;
                        }
                        if (MainClass.inChannel.position() < MainClass.inChannel.size()) continue;
                    }
                    catch (Exception e) {
                        System.err.println("Reading AudioChunk #" + this.audioInfoLen);
                        throw e;
                    }
                }
                this.chunkFile[fileId] = MainClass.inFile;
                this.chunkChannel[fileId] = MainClass.inChannel;
                if (++fileId >= 6) break;
                aFile = new File(pathDir.getParent().toString() + '\\' + additionalFiles[fileId]);
                MainClass.inFile = null;
                try {
                    MainClass.inFile = new FileInputStream(aFile);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace(System.err);
                }
                MainClass.inChannel = MainClass.inFile.getChannel();
            }
            System.err.println("Processing audio: " + this.audioInfoLen + " Done!");
            System.err.println("Integrity analysis:");
            for (i = 0; i < this.taggedSoundsLen; ++i) {
                if (this.taggedSounds[i].getSoundInfo() != null) continue;
                System.err.println("taggedSounds[" + i + "]: No SoundInfo for " + this.taggedSounds[i].getStrID());
            }
            for (i = 0; i < this.missionSoundsLen; ++i) {
                if (this.missionSounds[i].getSoundInfo() != null) continue;
                System.err.println("missionSounds[" + i + "]: No SoundInfo for " + this.missionSounds[i].getStrID());
            }
            for (i = 0; i < this.soundInfoLen; ++i) {
                if (this.soundInfo[i].getSoundTag() == null) {
                    System.err.println("soundInfo[" + i + "]: No TagInfo for subtitle group at " + this.soundInfo[i].getSubtitleTextOffset().toString() + ": " + this.soundInfo[i].getSubtitleText()[0].getSubCurrent());
                }
                for (int j = 0; j < this.soundInfo[i].getNumFiles(); ++j) {
                    this.soundInfo[i].getSubtitleText()[j].refreshAudioChunk();
                }
            }
            for (i = 0; i < this.audioInfoLen; ++i) {
                if (this.audioData[i].getSubtitleText() != null) continue;
                System.err.println("audioData[" + i + "]: No subtitle for audio chunk " + this.audioData[i].getAudioFileName() + " at " + this.audioData[i].getOffset().toString());
            }
            System.err.println("complete");
        }
        catch (Exception e) {
            this.closeInputFiles();
            throw e;
        }
    }

    public void closeInputFiles() throws IOException {
        for (int i = 2; i < 6; ++i) {
            if (this.chunkFile[i] == null) continue;
            this.chunkFile[i].close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printXML_(String path) {
        File bFile = new File(path);
        PrintStream outFile = null;
        try {
            int i;
            outFile = new PrintStream(bFile);
            outFile = MainClass.Options.encoding != null && !MainClass.Options.encoding.isEmpty() ? new PrintStream(bFile, MainClass.Options.encoding) : new PrintStream(bFile);
            System.setOut(outFile);
            System.out.println("<?xml version=\"1.0\"" + (MainClass.Options.encoding.isEmpty() ? "" : " encoding=\"" + MainClass.Options.encoding + "\"") + " ?>");
            System.out.println("<DeusExIWSoundFile>");
            WriteXML.printXML("aUnknown", this.aUnknown);
            System.out.println("<tagsList>");
            for (i = 0; i < this.tagsLen; ++i) {
                this.tags[i].printXML_();
            }
            System.out.println("</tagsList>");
            System.out.println("<taggedSounds>");
            int countBarrier = 5000;
            for (i = 0; i < this.taggedSoundsLen; ++i) {
                this.taggedSounds[i].printXML_();
                if (i <= countBarrier) continue;
                System.err.println("Printing tagged sounds: " + countBarrier + "...");
                countBarrier += 5000;
            }
            System.out.println("</taggedSounds>");
            System.out.println("<missionSounds>");
            countBarrier = 5000;
            for (i = 0; i < this.missionSoundsLen; ++i) {
                this.missionSounds[i].printXML_();
                if (i <= countBarrier) continue;
                System.err.println("Printing mission sounds: " + countBarrier + "...");
                countBarrier += 5000;
            }
            System.out.println("</missionSounds>");
            if (MainClass.Options.processAudioDVDs) {
                countBarrier = 5000;
                System.out.println("<audioData>");
                for (i = 0; i < this.audioInfoLen; ++i) {
                    this.audioData[i].printXML_();
                    if (i <= countBarrier) continue;
                    System.err.println("Printing XML audiodata: " + countBarrier + "...");
                    countBarrier += 5000;
                }
                System.out.println("</audioData>");
                System.err.println("Printing XML audiodata: " + this.audioInfoLen + " Done!");
            }
            System.out.println("</DeusExIWSoundFile>");
        }
        catch (FileNotFoundException ex) {
            System.err.println("Error: XML output file can not be created.");
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Error: encoding " + MainClass.Options.encoding + " is not recognized.");
        }
        finally {
            if (outFile != null) {
                outFile.flush();
                outFile.close();
            }
        }
        System.err.println(bFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTXT(String customPath) {
        if (customPath == null || customPath.isEmpty()) {
            customPath = this.path.substring(0, this.path.length() - 4) + ".txt";
        }
        File bFile = new File(customPath);
        PrintStream outFile = null;
        try {
            SM_SoundFileInfo subtitleText;
            int j;
            SM_SoundInfo soundInfo;
            int i;
            outFile = MainClass.Options.encoding != null && !MainClass.Options.encoding.isEmpty() ? new PrintStream(bFile, MainClass.Options.encoding) : new PrintStream(bFile);
            System.setOut(outFile);
            for (int i2 = 0; i2 < this.tagsLen; ++i2) {
                this.tags[i2].printTXT();
            }
            int countBarrier = 5000;
            for (i = 0; i < this.taggedSoundsLen; ++i) {
                soundInfo = this.taggedSounds[i].getSoundInfo();
                for (j = 0; j < soundInfo.getNumFiles(); ++j) {
                    subtitleText = soundInfo.getSubtitleText()[j];
                    if (MainClass.Options.detailed) {
                        System.out.println("" + i + "\t/\t" + j + "\t:\t" + subtitleText.getSubCurrent() + "\t" + subtitleText.getAudioFileName() + "\t'" + soundInfo.getSoundTag().getStrID());
                        continue;
                    }
                    System.out.println("" + i + "/" + j + ":" + subtitleText.getSubCurrent());
                }
                if (i <= countBarrier) continue;
                System.err.println("Printing TXT subtitles: " + countBarrier + "...");
                countBarrier += 5000;
            }
            for (i = 0; i < this.missionSoundsLen; ++i) {
                soundInfo = this.missionSounds[i].getSoundInfo();
                for (j = 0; j < soundInfo.getNumFiles(); ++j) {
                    subtitleText = soundInfo.getSubtitleText()[j];
                    if (MainClass.Options.detailed) {
                        System.out.println("" + (this.taggedSoundsLen + i) + "\t/\t" + j + "\t:\t" + subtitleText.getSubCurrent() + "\t" + subtitleText.getAudioFileName() + "\t'" + soundInfo.getSoundTag().getStrID());
                        continue;
                    }
                    System.out.println("" + (this.taggedSoundsLen + i) + "/" + j + ":" + subtitleText.getSubCurrent());
                }
                if (this.taggedSoundsLen + i <= countBarrier) continue;
                System.err.println("Printing TXT subtitles: " + countBarrier + "...");
                countBarrier += 5000;
            }
            System.err.println("Printing TXT subtitles: " + (this.taggedSoundsLen + this.missionSoundsLen) + " Done!");
            System.err.println(bFile.getAbsolutePath());
        }
        catch (FileNotFoundException ex) {
            System.err.println("Error: Print file " + customPath + " can not be created.");
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Error: encoding " + MainClass.Options.encoding + " is not recognized.");
        }
        finally {
            if (outFile != null) {
                outFile.flush();
                outFile.close();
            }
        }
    }

    public void refreshTaggedData() {
        SM_SoundFileInfo subtitleText;
        int j;
        SM_SoundInfo soundInfo;
        int i;
        int counter = 0;
        if (this.formData == null) {
            for (i = 0; i < this.taggedSoundsLen; ++i) {
                soundInfo = this.taggedSounds[i].getSoundInfo();
                counter += soundInfo.getNumFiles();
            }
            for (i = 0; i < this.missionSoundsLen; ++i) {
                soundInfo = this.missionSounds[i].getSoundInfo();
                counter += soundInfo.getNumFiles();
            }
            this.formData = new Object[counter][8];
        }
        counter = 0;
        for (i = 0; i < this.taggedSoundsLen; ++i) {
            soundInfo = this.taggedSounds[i].getSoundInfo();
            for (j = 0; j < soundInfo.getNumFiles(); ++j) {
                subtitleText = soundInfo.getSubtitleText()[j];
                this.formData[counter][0] = i;
                this.formData[counter][1] = j;
                this.formData[counter][2] = soundInfo.getTagInfo();
                this.formData[counter][3] = soundInfo.getSoundTag().getVoiceID();
                this.formData[counter][4] = subtitleText.getSubCurrent();
                this.formData[counter][5] = subtitleText.getSubOriginal();
                if (this.formData[counter][5] == null) {
                    this.formData[counter][5] = "";
                }
                this.formData[counter][6] = subtitleText.getAudioFileName();
                if (subtitleText.getAudioChunk() != null && subtitleText.getAudioChunk().getAudioFileName() != null) {
                    this.formData[counter][6] = subtitleText.getAudioChunk().getAudioFileName();
                }
                this.formData[counter][7] = subtitleText.getAudioFileOffset().getString();
                ++counter;
            }
        }
        try {
            for (i = 0; i < this.missionSoundsLen; ++i) {
                soundInfo = this.missionSounds[i].getSoundInfo();
                for (j = 0; j < soundInfo.getNumFiles(); ++j) {
                    subtitleText = soundInfo.getSubtitleText()[j];
                    this.formData[counter][0] = i + this.taggedSoundsLen;
                    this.formData[counter][1] = j;
                    this.formData[counter][2] = soundInfo.getTagInfo();
                    this.formData[counter][3] = soundInfo.getSoundTag().getVoiceID();
                    this.formData[counter][4] = subtitleText.getSubCurrent();
                    this.formData[counter][5] = subtitleText.getSubOriginal();
                    if (this.formData[counter][5] == null) {
                        this.formData[counter][5] = "";
                    }
                    this.formData[counter][6] = subtitleText.getAudioFileName();
                    if (subtitleText.getAudioChunk() != null && subtitleText.getAudioChunk().getAudioFileName() != null) {
                        this.formData[counter][6] = subtitleText.getAudioChunk().getAudioFileName();
                    }
                    this.formData[counter][7] = subtitleText.getAudioFileOffset().getString();
                    ++counter;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Unknown exception");
        }
    }

    public Object[][] formTaggedData() {
        if (this.formData == null) {
            this.refreshTaggedData();
        }
        return this.formData;
    }

    public void loadReferenceFile(CSC_SoundFile referenceFile) {
        SM_SoundFileInfo subtitleText2;
        SM_SoundFileInfo subtitleText;
        int j;
        SM_SoundInfo soundInfo2;
        SM_SoundInfo soundInfo;
        int i;
        for (i = 0; i < this.taggedSoundsLen; ++i) {
            soundInfo = this.taggedSounds[i].getSoundInfo();
            soundInfo2 = referenceFile.getTaggedSounds()[i].getSoundInfo();
            for (j = 0; j < soundInfo.getNumFiles(); ++j) {
                subtitleText = soundInfo.getSubtitleText()[j];
                subtitleText2 = soundInfo2.getSubtitleText()[j];
                subtitleText.setSubOriginal(subtitleText2.getSubCurrent());
            }
        }
        for (i = 0; i < this.missionSoundsLen; ++i) {
            soundInfo = this.missionSounds[i].getSoundInfo();
            soundInfo2 = referenceFile.getMissionSounds()[i].getSoundInfo();
            for (j = 0; j < soundInfo.getNumFiles(); ++j) {
                subtitleText = soundInfo.getSubtitleText()[j];
                subtitleText2 = soundInfo2.getSubtitleText()[j];
                subtitleText.setSubOriginal(subtitleText2.getSubCurrent());
            }
        }
        this.referenceFileLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printRawTXT(String customPath) {
        if (customPath == null || customPath.isEmpty()) {
            customPath = this.path.substring(0, this.path.length() - 4) + "_raw.txt";
        }
        File bFile = new File(customPath);
        PrintStream outFile = null;
        try {
            int i;
            outFile = MainClass.Options.encoding != null && !MainClass.Options.encoding.isEmpty() ? new PrintStream(bFile, MainClass.Options.encoding) : new PrintStream(bFile);
            System.setOut(outFile);
            for (int i2 = 0; i2 < this.tagsLen; ++i2) {
                this.tags[i2].printTXT();
            }
            int countBarrier = 5000;
            for (i = 0; i < this.taggedSoundsLen; ++i) {
                this.taggedSounds[i].printTXT();
            }
            for (i = 0; i < this.missionSoundsLen; ++i) {
                this.missionSounds[i].printTXT();
            }
            for (i = 0; i < this.soundInfoLen; ++i) {
                this.soundInfo[i].printTXT(i);
            }
            for (i = 0; i < this.audioInfoLen; ++i) {
                this.audioData[i].printTXT();
            }
            System.err.println("Printing TXT subtitles: " + (this.taggedSoundsLen + this.missionSoundsLen) + " Done!");
            System.err.println(bFile.getAbsolutePath());
        }
        catch (FileNotFoundException ex) {
            System.err.println("Error: Print file " + customPath + " can not be created.");
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Error: encoding " + MainClass.Options.encoding + " is not recognized.");
        }
        finally {
            if (outFile != null) {
                outFile.flush();
                outFile.close();
            }
        }
    }

    public void writeCsc(String path) throws IOException {
        if (!WriteCSC.isNullWrite()) {
            File bFile = new File(path);
            FileOutputStream bStream = new FileOutputStream(bFile);
            MainClass.conFile = new BufferedOutputStream(bStream, 16384);
        }
        WriteCSC.writeCsc(this.aUnknown);
        int i = 0;
        WriteCSC.writeCsc((byte)this.tagsLen);
        try {
            for (i = 0; i < this.tagsLen; ++i) {
                this.tags[i].writeCsc();
            }
        }
        catch (Exception e) {
            System.err.println("Forming tag #" + i);
            throw e;
        }
        WriteCSC.writeCsc((short)this.taggedSoundsLen);
        try {
            for (i = 0; i < this.taggedSoundsLen; ++i) {
                this.taggedSounds[i].writeCsc();
            }
        }
        catch (Exception e) {
            System.err.println("Forming taggedSound #" + i);
            throw e;
        }
        WriteCSC.writeCsc((short)this.missionSoundsLen);
        try {
            for (i = 0; i < this.missionSoundsLen; ++i) {
                this.missionSounds[i].writeCsc();
            }
        }
        catch (Exception e) {
            System.err.println("Forming missionSound #" + i);
            throw e;
        }
        try {
            for (i = 0; i < this.soundInfoLen; ++i) {
                this.soundInfo[i].writeCsc();
            }
        }
        catch (Exception e) {
            System.err.println("Forming soundInfo #" + i);
            throw e;
        }
        try {
            for (i = 0; i < this.audioInfoLen; ++i) {
                if (this.audioData[i].getOffset().getFileID() != 2) continue;
                this.audioData[i].writeCsc();
            }
        }
        catch (Exception e) {
            System.err.println("Forming audioData #" + i);
            throw e;
        }
    }

    public void importText(String path) {
        String debugLine = "";
        try {
            List<String> allLines = Files.readAllLines(Paths.get(path, new String[0]), Charset.forName(MainClass.Options.encoding));
            Iterator<String> iterator = allLines.iterator();
            while (iterator.hasNext()) {
                SM_TaggedSound lineInfo;
                int sublineNum;
                int lineNum;
                String line;
                debugLine = line = iterator.next();
                if (line.isEmpty()) continue;
                int sublinePos = line.indexOf("/");
                int textPos = line.indexOf(":");
                if (sublinePos <= 0 || textPos <= 1) {
                    System.err.println("\"" + line.substring(0, 30) + "...\" - not a Line/Subline:Text format line - ignored.");
                    continue;
                }
                try {
                    lineNum = Integer.parseInt(line.substring(0, sublinePos).trim());
                    sublineNum = Integer.parseInt(line.substring(sublinePos + 1, textPos).trim());
                }
                catch (NumberFormatException e) {
                    System.err.println("\"" + line.substring(0, 30) + "...\" - not a Line/Subline:Text format line - ignored.");
                    continue;
                }
                if (lineNum >= this.taggedSoundsLen + this.missionSoundsLen) {
                    System.err.println("\"" + line.substring(0, 30) + "...\" - Line number outside of bounds - ignored.");
                    continue;
                }
                SM_SoundTagData sM_SoundTagData = lineInfo = lineNum >= this.taggedSoundsLen ? this.missionSounds[lineNum - this.taggedSoundsLen] : this.taggedSounds[lineNum];
                if (sublineNum >= lineInfo.getSoundInfo().getNumFiles()) {
                    System.err.println("\"" + line.substring(0, 30) + "...\" - SubLine number outside of bounds for what looks like \"" + lineInfo.getSoundInfo().getTagInfo() + "\" - ignored.");
                    continue;
                }
                if (line.length() > textPos + 1 && line.substring(textPos + 1, textPos + 2).equals("\t")) {
                    int lineEnd = line.indexOf("\t", textPos + 2);
                    if (lineEnd == -1) {
                        lineEnd = 2000;
                    }
                    line = line.substring(textPos + 2, lineEnd);
                } else {
                    line = line.substring(textPos + 1);
                }
                line = line.trim();
                if (line.isEmpty()) {
                    line = null;
                }
                lineInfo.getSoundInfo().getSubtitleText()[sublineNum].setSubCurrent(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Error processing line:");
            System.err.println(debugLine);
            e.printStackTrace();
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public SM_Tag[] getTags() {
        return this.tags;
    }

    public void setTags(SM_Tag[] tags) {
        this.tags = tags;
    }

    public Map<SM_Offset, SM_SoundFileInfo> getAudioMap() {
        return this.audioMap;
    }

    public Map<SM_Offset, SM_SoundTagData> getSoundMap() {
        return this.soundMap;
    }

    public Map<SM_Offset, SM_AudioChunk> getAudioNameMap() {
        return this.audioNameMap;
    }

    public Map<String, SM_SoundTagData> getMissionSoundMap() {
        return this.missionSoundMap;
    }

    public void setAudioNameMap(Map<SM_Offset, SM_AudioChunk> audioNameMap) {
        this.audioNameMap = audioNameMap;
    }

    public SM_TaggedSound[] getTaggedSounds() {
        return this.taggedSounds;
    }

    public SM_MissionSound[] getMissionSounds() {
        return this.missionSounds;
    }

    public SM_SoundInfo[] getSoundInfo() {
        return this.soundInfo;
    }

    public int getTagsLen() {
        return this.tagsLen;
    }

    public int getTaggedSoundsLen() {
        return this.taggedSoundsLen;
    }

    public int getMissionSoundsLen() {
        return this.missionSoundsLen;
    }

    public int getSoundInfoLen() {
        return this.soundInfoLen;
    }

    public int getAudioInfoLen() {
        return this.audioInfoLen;
    }

    public boolean isReferenceFileLoaded() {
        return this.referenceFileLoaded;
    }

    public boolean isFileChanged() {
        return this.fileChanged;
    }

    public void setFileChanged(boolean fileChanged) {
        this.fileChanged = fileChanged;
    }

    public String[] getTagsList() {
        if (this.tagSelectionData == null) {
            this.tagSelectionData = new String[this.tagsLen + 1];
            this.tagSelectionData[0] = "";
            for (int i = 0; i < this.tagsLen; ++i) {
                this.tagSelectionData[i + 1] = this.tags[i].getStrTagName();
            }
            Arrays.sort(this.tagSelectionData);
        }
        return this.tagSelectionData;
    }

    public FileChannel[] getChunkChannel() {
        return this.chunkChannel;
    }

    public FileInputStream[] getChunkFile() {
        return this.chunkFile;
    }

    public String[][] getSubTagsList() {
        if (this.subTagSelectionData == null) {
            int i;
            int listLen = 12;
            for (i = 0; i < this.tagsLen; ++i) {
                listLen += this.tags[i].getNumSubTags();
            }
            this.subTagSelectionData = new String[listLen][2];
            this.subTagSelectionData[0][0] = "";
            this.subTagSelectionData[0][1] = "";
            this.subTagSelectionData[1][0] = "gencit";
            this.subTagSelectionData[1][1] = "+voice";
            this.subTagSelectionData[2][0] = "gencitegyptian";
            this.subTagSelectionData[2][1] = "+voice";
            this.subTagSelectionData[3][0] = "gencitgerman";
            this.subTagSelectionData[3][1] = "+voice";
            this.subTagSelectionData[4][0] = "gencitscientist";
            this.subTagSelectionData[4][1] = "+voice";
            this.subTagSelectionData[5][0] = "gencitupper";
            this.subTagSelectionData[5][1] = "+voice";
            this.subTagSelectionData[6][0] = "gencitworking";
            this.subTagSelectionData[6][1] = "+voice";
            this.subTagSelectionData[7][0] = "orderguard";
            this.subTagSelectionData[7][1] = "+voice";
            this.subTagSelectionData[8][0] = "ssc";
            this.subTagSelectionData[8][1] = "+voice";
            this.subTagSelectionData[9][0] = "templarguard";
            this.subTagSelectionData[9][1] = "+voice";
            this.subTagSelectionData[10][0] = "thug";
            this.subTagSelectionData[10][1] = "+voice";
            this.subTagSelectionData[11][0] = "wto";
            this.subTagSelectionData[11][1] = "+voice";
            listLen = 12;
            for (i = 0; i < this.tagsLen; ++i) {
                for (int j = 0; j < this.tags[i].getNumSubTags(); ++j) {
                    this.subTagSelectionData[listLen][0] = this.tags[i].getSubTag(j);
                    this.subTagSelectionData[listLen][1] = this.tags[i].getStrTagName();
                    ++listLen;
                }
            }
            Arrays.sort(this.subTagSelectionData, new DoubleStringComparator());
        }
        return this.subTagSelectionData;
    }

    public class DoubleStringComparator
    implements Comparator<String[]> {
        @Override
        public int compare(String[] emp1, String[] emp2) {
            int i = 0;
            try {
                i = emp1[1].compareTo(emp2[1]);
                if (i == 0) {
                    i = emp1[0].compareTo(emp2[0]);
                }
            }
            catch (Exception e) {
                System.err.println(emp1[0]);
                System.err.println(emp1[1]);
                System.err.println(emp2[0]);
                System.err.println(emp2[1]);
                throw e;
            }
            return i;
        }
    }
}

