/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export;

import java.io.ByteArrayOutputStream;

public class CustomWAV {
    private static final int[] stepsizeTable = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
    private static final int[] indexTable = new int[]{-1, -1, -1, -1, 2, 4, 6, 8, -1, -1, -1, -1, 2, 4, 6, 8};
    private static int inputPosition = 0;
    private static boolean nibbleFlip;
    private static byte[] dataSource;

    public static byte[] decode(byte[] source) {
        inputPosition = 0;
        nibbleFlip = false;
        dataSource = source;
        int newSample = 0;
        int index = 0;
        int stepsize = 0;
        int sample = 0;
        int delta = 0;
        int reserved = 0;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        newSample = CustomWAV.readInt();
        index = CustomWAV.readShort();
        reserved = CustomWAV.readShort();
        stepsize = stepsizeTable[index];
        while (inputPosition < dataSource.length) {
            sample = CustomWAV.readNibble();
            delta = 0;
            if ((sample & 4) > 0) {
                delta += stepsize;
            }
            if ((sample & 2) > 0) {
                delta += stepsize >> 1;
            }
            if ((sample & 1) > 0) {
                delta += stepsize >> 2;
            }
            delta += stepsize >> 3;
            if ((sample & 8) > 0) {
                delta = -delta;
            }
            if ((newSample += delta) > Short.MAX_VALUE) {
                newSample = Short.MAX_VALUE;
            } else if (newSample < Short.MIN_VALUE) {
                newSample = Short.MIN_VALUE;
            }
            outputStream.write(newSample & 0xFF);
            outputStream.write(newSample >> 8 & 0xFF);
            if ((index += indexTable[sample]) < 0) {
                index = 0;
            } else if (index > 88) {
                index = 88;
            }
            stepsize = stepsizeTable[index];
        }
        return outputStream.toByteArray();
    }

    private static int readInt() {
        int result = 0;
        result = result + dataSource[inputPosition] + dataSource[inputPosition + 1] * 256;
        inputPosition += 2;
        return result;
    }

    private static int readShort() {
        int result = 0;
        result += dataSource[inputPosition];
        ++inputPosition;
        return result;
    }

    private static int readNibble() {
        int result = 0;
        if (nibbleFlip) {
            result = dataSource[inputPosition] & 0xF;
        } else {
            result = dataSource[inputPosition] >> 4;
            ++inputPosition;
        }
        nibbleFlip = !nibbleFlip;
        return result;
    }
}

