/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export;

import com.mycompany.csc_export.CSC_SoundFile;
import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.SM_AudioChunk;
import com.mycompany.csc_export.SM_SoundFileInfo;
import com.mycompany.csc_export.SM_SoundTagData;
import com.mycompany.csc_export.WriteCSC;
import com.mycompany.csc_export.con_parser.CONtainer;
import com.mycompany.csc_export.con_parser.Conversation;
import com.mycompany.csc_export.con_parser.TableLine;
import com.mycompany.csc_export.coneditform.ConEditDetailedJFrame;
import com.mycompany.csc_export.coneditform.ConTableCellRenderer;
import com.mycompany.csc_export.coneditform.ConTableModel;
import com.mycompany.csc_export.coneditform.ConeditJFrame;
import com.mycompany.csc_export.formcomponents.LongEditJFrame;
import com.mycompany.csc_export.formcomponents.MyTableModel;
import com.mycompany.csc_export.formcomponents.NewJFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class DemoForm
extends JPanel {
    private static Object[][] data;
    private static CSC_SoundFile sourceFile;
    private static String sourceFilePath;
    public static final int LINE = 0;
    public static final int SUBLINE = 1;
    public static final int TAGS = 2;
    public static final int VOICE = 3;
    public static final int TEXT = 4;
    public static final int ORIGINAL = 5;
    public static final int AUDIOFILE = 6;
    public static final int OFFSET = 7;
    public static CONtainer convoSet;
    private static List<JFrame> windowsList;
    private static Clip clip;
    private static TreeSet<String> scriptedNames;

    public DemoForm() {
        super(new GridLayout(1, 0));
        this.setLayout(new BoxLayout(this, 1));
    }

    private static void createAndShowGUI() {
        NewJFrame frame;
        NewJFrame frameB = frame = new NewJFrame("CSC Simple Editor - " + sourceFile.getPath());
        Component[] frameComponents = frame.getContentPane().getComponents();
        List<Component> frameComponentList = Arrays.asList(frameComponents);
        final JTable table = frameB.getTable();
        MyTableModel model = new MyTableModel(data);
        table.setModel(model);
        table.setRowSorter(new TableRowSorter<MyTableModel>(model));
        table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        table.setFillsViewportHeight(true);
        table.getColumnModel().getColumn(0).setMaxWidth(50);
        table.getColumnModel().getColumn(1).setMaxWidth(30);
        table.getColumnModel().getColumn(3).setMaxWidth(150);
        table.getColumnModel().getColumn(6).setMaxWidth(150);
        table.getColumnModel().getColumn(7).setMaxWidth(95);
        table.setCellSelectionEnabled(true);
        if (!sourceFile.isReferenceFileLoaded()) {
            table.getColumnModel().getColumn(5).setMinWidth(0);
            table.getColumnModel().getColumn(5).setMaxWidth(0);
            table.getColumnModel().getColumn(5).setWidth(0);
            frameB.hidesearchFields();
        }
        frame.setDefaultCloseOperation(2);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                AudioInputStream inputStream;
                int column;
                int row;
                JTable target;
                if (me.getClickCount() == 2) {
                    target = (JTable)me.getSource();
                    row = target.getSelectedRow();
                    column = target.getSelectedColumn();
                    if (column == 0 || column == 1) {
                        int dataRow = table.getRowSorter().convertRowIndexToModel(row);
                        DemoForm.alignSelectedRow(dataRow);
                        return;
                    }
                    if (column == 6 || column == 7 || column == 5) {
                        try {
                            inputStream = DemoForm.getAudioStream(row, table);
                            if (inputStream != null) {
                                clip.stop();
                                clip.close();
                                clip.open(inputStream);
                                clip.start();
                            }
                        }
                        catch (LineUnavailableException ex) {
                            Logger.getLogger(DemoForm.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(DemoForm.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                if (me.getButton() == 3) {
                    target = (JTable)me.getSource();
                    row = target.rowAtPoint(me.getPoint());
                    column = target.columnAtPoint(me.getPoint());
                    if (column == 4 || column == 5) {
                        target.changeSelection(row, column, false, false);
                        try {
                            inputStream = DemoForm.getAudioStream(row, table);
                            if (inputStream != null) {
                                clip.stop();
                                clip.close();
                                clip.open(inputStream);
                            }
                        }
                        catch (LineUnavailableException ex) {
                            Logger.getLogger(DemoForm.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(DemoForm.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        LongEditJFrame longEdit = new LongEditJFrame(target.getValueAt(row, 4), target.getValueAt(row, 5));
                        longEdit.pack();
                        longEdit.setLocation(me.getLocationOnScreen());
                        longEdit.setVisible(true);
                        target.setValueAt(longEdit.getText(), row, 4);
                        clip.stop();
                    }
                }
            }
        });
        frame.pack();
        frame.setVisible(true);
        windowsList.add(frame);
    }

    private static void createAndShowConvoGUI() {
        ConeditJFrame frame;
        ConeditJFrame frameB = frame = new ConeditJFrame();
        String map = null;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
        DefaultMutableTreeNode mapNode = null;
        for (Conversation c : convoSet.getConvos()) {
            if (!c.getMap().equals(map)) {
                if (mapNode != null) {
                    root.add(mapNode);
                }
                map = c.getMap();
                mapNode = new DefaultMutableTreeNode(map);
            }
            DefaultMutableTreeNode convoNode = new DefaultMutableTreeNode(c.getName());
            for (int i = 0; i < c.getConditions().size(); ++i) {
                convoNode.add(c.getConditions().get(i).generateNode());
            }
            mapNode.add(convoNode);
        }
        root.add(mapNode);
        JTree subTree = frameB.getjTree1();
        JTree tree = new JTree(root);
        subTree.setModel(tree.getModel());
        subTree.setRootVisible(false);
        subTree.setSelectionPath(new TreePath(root.getChildAt(0).getChildAt(0)));
        final JTable table = frameB.getjTable1();
        final ConTableModel model = new ConTableModel(null);
        table.setModel(model);
        table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        table.setFillsViewportHeight(true);
        table.getColumnModel().getColumn(0).setPreferredWidth(100);
        table.getColumnModel().getColumn(1).setPreferredWidth(100);
        table.getColumnModel().getColumn(2).setPreferredWidth(600);
        table.getColumnModel().getColumn(3).setPreferredWidth(200);
        table.getColumnModel().getColumn(3).setMaxWidth(300);
        table.setCellSelectionEnabled(true);
        table.setDefaultRenderer(Object.class, new ConTableCellRenderer());
        table.setAlignmentX(1.0f);
        frameB.getjScrollPaneTable().setVerticalScrollBarPolicy(22);
        frame.setDefaultCloseOperation(2);
        subTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object selectedNode = e.getNewLeadSelectionPath().getLastPathComponent();
                if (selectedNode == null) {
                    return;
                }
                String selectedNodeName = selectedNode.toString();
                Conversation selectedConvo = convoSet.getConvos().stream().filter(c -> c.getName().equals(selectedNodeName)).findFirst().orElse(null);
                if (selectedConvo != null) {
                    model.setTableLines(selectedConvo.getTableLines());
                    table.clearSelection();
                    table.setRowHeight(table.getRowHeight());
                    table.repaint();
                }
            }
        });
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                TableLine line;
                int column;
                int row;
                JTable target;
                if (me.getClickCount() == 2) {
                    target = (JTable)me.getSource();
                    row = target.getSelectedRow();
                    column = target.getSelectedColumn();
                    line = model.getTableLines().get(row);
                    if (column == 2 && line.getLineM() != null) {
                        DemoForm.playPreparedAudio(line.getLineM().getAudioChunk());
                    }
                    if (column == 3 && !line.getAudioTag().isEmpty()) {
                        DemoForm.alignSelectedRow(line.getAudioTag() + "_");
                    }
                }
                if (me.getButton() == 3) {
                    target = (JTable)me.getSource();
                    row = target.rowAtPoint(me.getPoint());
                    column = target.columnAtPoint(me.getPoint());
                    line = model.getTableLines().get(row);
                    if (column == 2 && line.getLineM() != null) {
                        ConEditDetailedJFrame longEdit = new ConEditDetailedJFrame(line);
                        longEdit.pack();
                        longEdit.setLocation(me.getLocationOnScreen());
                        longEdit.setVisible(true);
                        line.setText(line.getLineM().getSubCurrent());
                        table.repaint();
                    }
                }
            }
        });
        frame.pack();
        frame.setVisible(true);
        windowsList.add(frame);
    }

    public static void updateSubtitle(String value, TableLine line, boolean femaleTag) {
        SM_SoundFileInfo subtitle;
        SM_SoundFileInfo sM_SoundFileInfo = subtitle = femaleTag ? line.getLineF() : line.getLineM();
        if (!subtitle.getSubCurrent().equals(value)) {
            subtitle.setSubCurrent(value);
            if (!femaleTag) {
                line.setText(value);
            }
            sourceFile.setFileChanged(true);
        }
    }

    private static void dummySetComponent(Component item) {
        if (item.getName() != null && item.getName().equals("searchOriginal")) {
            item.setVisible(false);
        }
    }

    public static void playPreparedAudio() {
        clip.setMicrosecondPosition(0L);
        clip.start();
    }

    public static void playPreparedAudio(SM_AudioChunk playChunk) {
        AudioInputStream inputStream = DemoForm.getAudioStream(playChunk);
        if (inputStream != null) {
            try {
                clip.stop();
                clip.close();
                clip.open(inputStream);
                clip.start();
            }
            catch (LineUnavailableException ex) {
                Logger.getLogger(DemoForm.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(DemoForm.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static AudioInputStream getAudioStream(int row, JTable table) {
        int lineNo = (Integer)table.getValueAt(row, 0);
        int subNo = (Integer)table.getValueAt(row, 1);
        SM_SoundTagData playLine = lineNo < sourceFile.getTaggedSoundsLen() ? sourceFile.getTaggedSounds()[lineNo] : sourceFile.getMissionSounds()[lineNo - sourceFile.getTaggedSoundsLen()];
        SM_AudioChunk playChunk = playLine.getSoundInfo().getSubtitleText()[subNo].getAudioChunk();
        return DemoForm.getAudioStream(playChunk);
    }

    private static AudioInputStream getAudioStream(SM_AudioChunk playChunk) {
        AudioInputStream inputStream = null;
        if (playChunk == null || playChunk.getOffset().getFileID() < 2 || playChunk.getOffset().getFileID() > 5 || playChunk.getPhysicalSize() == 0) {
            return null;
        }
        String audioFileName = sourceFilePath + "\\audio\\" + playChunk.getAudioFileName();
        File audioFile = new File(audioFileName);
        if (audioFile.exists()) {
            try {
                inputStream = AudioSystem.getAudioInputStream(audioFile);
            }
            catch (UnsupportedAudioFileException ex) {
                Logger.getLogger(DemoForm.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(DemoForm.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            MainClass.inChannel = sourceFile.getChunkChannel()[playChunk.getOffset().getFileID()];
            MainClass.inFile = sourceFile.getChunkFile()[playChunk.getOffset().getFileID()];
            if (playChunk.getAudioData() != null) {
                try {
                    ByteArrayInputStream virtualStream = new ByteArrayInputStream(playChunk.getAudioData());
                    inputStream = AudioSystem.getAudioInputStream(virtualStream);
                }
                catch (UnsupportedAudioFileException ex) {
                    Logger.getLogger(DemoForm.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(DemoForm.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return inputStream;
    }

    private static void alignSelectedRow(int row) {
        for (JFrame frame : windowsList) {
            if (!frame.getClass().getSimpleName().equals("NewJFrame")) continue;
            JTable table = ((NewJFrame)frame).getTable();
            int tableRow = table.getRowSorter().convertRowIndexToView(row);
            table.changeSelection(tableRow, 0, false, false);
        }
    }

    private static void alignSelectedRow(String tag) {
        for (int i = 0; i < data.length; ++i) {
            if (!((String)data[i][2]).toLowerCase().startsWith(tag.toLowerCase())) continue;
            DemoForm.alignSelectedRow(i);
            break;
        }
    }

    public static void removeWindow(JFrame frame) {
        windowsList.remove(frame);
        if (!windowsList.isEmpty()) {
            return;
        }
        int needSaving = sourceFile.isFileChanged() ? JOptionPane.showConfirmDialog(null, "Save " + sourceFile.getPath() + "before exiting?", "File changed", 1) : 1;
        switch (needSaving) {
            case 0: {
                DemoForm.saveFile(sourceFile.getPath());
            }
            case 1: {
                try {
                    sourceFile.closeInputFiles();
                }
                catch (IOException ex) {
                    Logger.getLogger(DemoForm.class.getName()).log(Level.SEVERE, null, ex);
                }
                System.exit(0);
            }
            case 2: {
                DemoForm.addWindow();
            }
        }
    }

    public static void addWindow() {
        DemoForm.createAndShowGUI();
    }

    public static void saveFile(String path) {
        try {
            WriteCSC.setFilePosition(0);
            WriteCSC.setNullWrite(true);
            sourceFile.writeCsc("nul");
            WriteCSC.setFilePosition(0);
            WriteCSC.setNullWrite(false);
            sourceFile.writeCsc(path);
            if (MainClass.conFile != null) {
                MainClass.conFile.flush();
                MainClass.conFile.close();
            }
            sourceFile.setFileChanged(false);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Error saving file.", "Error", 0);
        }
    }

    public static void testForm(CSC_SoundFile source) {
        try {
            if (clip == null) {
                clip = AudioSystem.getClip();
            }
        }
        catch (LineUnavailableException ex) {
            Logger.getLogger(DemoForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DemoForm.createAndShowGUI();
            }
        });
    }

    public static void convoForm(final CONtainer source) {
        try {
            if (clip == null) {
                clip = AudioSystem.getClip();
            }
        }
        catch (LineUnavailableException ex) {
            Logger.getLogger(DemoForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        DemoForm.fillDialogueVoices();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                convoSet = source;
                DemoForm.createAndShowConvoGUI();
            }
        });
    }

    public static CSC_SoundFile getSourceFile() {
        return sourceFile;
    }

    public static void fillDialogueVoices() {
        scriptedNames.add("");
        for (int i = data.length - 1; i >= 0 && !((String)data[i][2]).startsWith("+"); --i) {
            String actor;
            String tag = (String)data[i][2];
            if (tag.endsWith("_male")) {
                tag = tag.substring(0, tag.length() - 5);
            }
            if (tag.endsWith("_female")) {
                tag = tag.substring(0, tag.length() - 7);
            }
            if ((actor = CONtainer.getDialogueMap().get(tag)) == null) continue;
            String actorName = CONtainer.getFriendlyNameMap().get(actor);
            if (actorName != null) {
                actor = actorName + " (" + actor + ")";
            }
            DemoForm.data[i][3] = actor;
            scriptedNames.add(actor);
        }
    }

    public static Object[] generageScroptedNPCs() {
        Object[] scriptedNPCs = scriptedNames.toArray();
        return scriptedNPCs;
    }

    public static void setSourceFile(CSC_SoundFile sourceFile) {
        DemoForm.sourceFile = sourceFile;
        sourceFilePath = new File(sourceFile.getPath()).getParent();
        data = sourceFile.formTaggedData();
    }

    public static void printTXT(String path) {
        MainClass.Options.detailed = false;
        sourceFile.printTXT(path);
    }

    public static void printXML(String path) {
        sourceFile.printXML_(path);
    }

    public static void importTXT(String path) {
        sourceFile.importText(path);
    }

    static {
        windowsList = new ArrayList<JFrame>();
        scriptedNames = new TreeSet();
    }
}

