/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export;

import com.mycompany.csc_export.CSC_SoundFile;
import com.mycompany.csc_export.DemoForm;
import com.mycompany.csc_export.ReadCSC;
import com.mycompany.csc_export.WriteCSC;
import com.mycompany.csc_export.con_parser.CONtainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MainClass {
    public static FileChannel inChannel;
    public static FileChannel outChannel;
    public static FileInputStream inFile;
    public static OutputStream conFile;
    public static int dummyPointer;

    public static void main(String[] args) throws FileStructureException, IOException, SAXException, ParserConfigurationException, Exception {
        Path path = null;
        boolean exists = false;
        boolean isFile = false;
        ArrayList<String> filesToProcess = new ArrayList<String>();
        block97: for (int i = 0; i < args.length; ++i) {
            switch (args[i].toLowerCase()) {
                case "\\x": 
                case "-x": {
                    Options.outputXML = true;
                    continue block97;
                }
                case "\\c": 
                case "-c": {
                    Options.outputCSC = true;
                    Options.processAudioDVDs = true;
                    continue block97;
                }
                case "\\t": 
                case "-t": {
                    Options.outputTXT = true;
                    continue block97;
                }
                case "\\r": 
                case "-r": {
                    Options.rearrangeTags = true;
                    continue block97;
                }
                case "\\f": 
                case "-f": {
                    Options.editForm = true;
                    continue block97;
                }
                case "\\m": 
                case "-m": {
                    Options.missionForm = true;
                    continue block97;
                }
                case "\\d": 
                case "-d": {
                    Options.detailed = true;
                    Options.processAudioDVDs = true;
                    continue block97;
                }
                case "\\h": 
                case "-h": 
                case "-?": 
                case "\\?": {
                    Options.printUsage = true;
                    continue block97;
                }
                case "\\e": 
                case "-e": {
                    if (i >= args.length) continue block97;
                    Options.encoding = args[++i];
                    continue block97;
                }
                case "\\o": 
                case "-o": {
                    if (i >= args.length) continue block97;
                    Options.referenceFile = args[++i];
                    continue block97;
                }
                case "\\i": 
                case "-i": {
                    if (i >= args.length) continue block97;
                    Options.outputCSC = true;
                    Options.processAudioDVDs = true;
                    Options.importFile = args[++i];
                    continue block97;
                }
                case "\\l": 
                case "-l": {
                    if (i >= args.length || args[i + 1].length() != 1) continue block97;
                    switch (args[++i].toLowerCase()) {
                        case "f": {
                            Options.importFileLang = 1;
                            continue block97;
                        }
                        case "i": {
                            Options.importFileLang = 2;
                            continue block97;
                        }
                        case "g": {
                            Options.importFileLang = 3;
                            continue block97;
                        }
                        case "s": {
                            Options.importFileLang = 4;
                            continue block97;
                        }
                    }
                    System.err.println("'-l' sub-parameter must refer to [F]rench, [I]talian, [G]erman, or [S]panish");
                    continue block97;
                }
            }
        }
        boolean bl = Options.editForm = Options.editForm || !Options.outputCSC && !Options.outputXML && !Options.outputTXT;
        if (Options.outputCSC && Options.outputXML) {
            System.out.println("'Output as XML' and 'Compile XML->CSC' modes can not be used together");
            return;
        }
        String extention = !Options.outputCSC || Options.importFile != null ? "csc" : "xml";
        block98: for (int i = 0; i < args.length; ++i) {
            switch (args[i].toLowerCase()) {
                case "\\x": 
                case "-x": 
                case "\\c": 
                case "-c": 
                case "\\t": 
                case "-t": 
                case "\\f": 
                case "-f": 
                case "\\m": 
                case "-m": 
                case "\\r": 
                case "-r": 
                case "\\d": 
                case "-d": 
                case "\\h": 
                case "-h": 
                case "-?": 
                case "\\?": {
                    continue block98;
                }
                case "\\e": 
                case "-e": 
                case "\\l": 
                case "-l": 
                case "\\o": 
                case "-o": 
                case "\\i": 
                case "-i": {
                    ++i;
                    continue block98;
                }
                default: {
                    path = new File(args[i]).toPath();
                    exists = Files.exists(path, new LinkOption[0]);
                    isFile = Files.isRegularFile(path, new LinkOption[0]);
                    if (!exists) {
                        System.err.println("'" + args[i] + "' parameter must be a path or ." + extention + " file name");
                        System.exit(-1);
                    }
                    if (!isFile) continue block98;
                    if (path.toString().toLowerCase().endsWith("." + extention)) {
                        filesToProcess.add(path.toString());
                        continue block98;
                    }
                    System.err.println("'" + args[i] + "' parameter must be a ." + extention + " file name");
                    System.exit(-1);
                }
            }
        }
        if (Options.printUsage) {
            System.out.println("Usage: java -jar CSC_Export.jar [path]... [-keys]...");
            System.out.println("");
            System.out.println("If no path is specified, SchemaMetafile_HardDrive.csc in the current folder is used");
            System.out.println("");
            System.out.println("-t : Text mode - Scans CSC file(s) and generates text export .txt files more detailed than standard TagEdit export feature.");
            System.out.println("");
            System.out.println("-x: XML mode - Creates XML files instead of readable text. Not compatible with CSC mode.");
            System.out.println("");
            System.out.println("-f (default): form mode - Opens a primitive editing form to edit the file manually.");
            System.out.println("");
            System.out.println("-l [f|i|g|s]: Uses French, Italian, German, or Spanish lines instead of default English");
            System.out.println("");
            System.out.println("-i filename: Imports a text file and produces an updated CSC file (renamed).");
            System.out.println("    (Important! No altering the structure of text is possible; rearranging lines is OK, but every line must have its 'Num/SubNum:' tag exactly as it was generated. If you need to add/delete subtitles or fix audio links, use CSC mode for XML file import)");
            System.out.println("");
            System.out.println("-o filename: (form mode) - Imports a second CSC file and displays both files' subtitles side by side.");
            System.out.println("");
            System.out.println("-d: detailed output (text mode) provides full listing of internal data for analysis; also scans all four SchemaMetafile_*.csc files' audio chunks and includes their description in the output");
            System.out.println("");
            System.out.println("-e encoding: overrides system default encoding (may be needed for processing non-English translations).");
            if (filesToProcess.isEmpty()) {
                return;
            }
        }
        if (filesToProcess.isEmpty()) {
            path = new File(System.getProperty("user.dir")).toPath();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "SchemaMetafile_HardDrive.csc");){
                for (Path entry : stream) {
                    filesToProcess.add(entry.toString());
                }
            }
            catch (DirectoryIteratorException ex) {
                throw ex.getCause();
            }
        }
        if (filesToProcess.isEmpty()) {
            System.out.println("The specified folder contains no ." + extention + " files.");
        }
        if (filesToProcess.size() > 1 && Options.editForm) {
            System.out.println("You can not specify more than one input file for -f mode");
            return;
        }
        System.setErr(new PrintStream((OutputStream)System.err, true, Options.encoding));
        for (String s : filesToProcess) {
            MainClass.processFile(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processFile(String path) throws IOException, SAXException, ParserConfigurationException, Exception {
        CSC_SoundFile dataFile = null;
        CONtainer convoFile = null;
        try {
            dataFile = new CSC_SoundFile(path, true);
            if (Options.outputXML) {
                dataFile.printXML_(path.substring(0, path.length() - 4) + ".xml");
            }
            if (Options.outputTXT) {
                dataFile.printTXT(null);
                dataFile.printRawTXT(null);
            }
            if (Options.importFile != null) {
                if (!Files.exists(Paths.get(Options.importFile, new String[0]), new LinkOption[0])) {
                    System.err.println("No valid import file specified");
                }
                dataFile.importText(Options.importFile);
            }
            if (Options.referenceFile != null) {
                CSC_SoundFile dataFileOriginal = new CSC_SoundFile(Options.referenceFile, false);
                dataFile.loadReferenceFile(dataFileOriginal);
            }
            if (Options.missionForm) {
                convoFile = new CONtainer(path);
            }
            if (Options.editForm) {
                DemoForm.testForm(dataFile);
            }
            DemoForm.setSourceFile(dataFile);
            if (Options.missionForm) {
                DemoForm.convoForm(convoFile);
            }
        }
        catch (Exception e) {
            System.err.println("Fatal error: File " + path + " at " + ReadCSC.getFilePosition(0));
            System.err.println("");
            throw e;
        }
        try {
            if (Options.outputCSC) {
                WriteCSC.setFilePosition(0);
                WriteCSC.setNullWrite(true);
                dataFile.writeCsc("nul");
                WriteCSC.setFilePosition(0);
                WriteCSC.setNullWrite(false);
                path = path.substring(0, path.length() - 4) + "_new.csc";
                dataFile.writeCsc(path);
            }
        }
        catch (Exception e) {
            System.err.println("Fatal error: File " + path + " at " + WriteCSC.getFilePosition());
            System.err.println("");
        }
        finally {
            if (conFile != null) {
                conFile.flush();
                conFile.close();
            }
        }
    }

    static {
        inFile = null;
        conFile = null;
        dummyPointer = 0;
    }

    public static class XMLStructureException
    extends Exception {
        public XMLStructureException(String description, Node node) throws IOException {
            System.err.println("Can't find " + description + " in node " + node.getNodeName());
        }
    }

    public static class FileStructureException
    extends Exception {
        public FileStructureException(String description) throws IOException {
            System.err.println(description + " at " + ReadCSC.getFilePosition(0));
        }
    }

    public static class IllegalReadException
    extends Exception {
        public IllegalReadException() throws IOException {
            System.err.println("Can't read at " + ReadCSC.getFilePosition(0));
        }
    }

    public static class Options {
        public static boolean outputCSC = false;
        public static boolean outputXML = false;
        public static boolean outputTXT = false;
        public static boolean printUsage = false;
        public static boolean editForm = false;
        public static boolean missionForm = false;
        public static boolean detailed = false;
        public static boolean processAudioDVDs = false;
        public static String encoding = Charset.defaultCharset().displayName();
        public static String importFile = null;
        public static int importFileLang = 0;
        public static boolean rearrangeTags = false;
        public static String referenceFile = null;
    }
}

