/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export;

import com.mycompany.csc_export.CSC_SoundFile;
import com.mycompany.csc_export.MainClass;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ReadCSC {
    private static CSC_SoundFile currentFile;

    public static int readByte() throws IOException, MainClass.IllegalReadException {
        ByteBuffer intBuf = ByteBuffer.allocate(1);
        if (MainClass.inChannel.read(intBuf) == -1) {
            throw new MainClass.IllegalReadException();
        }
        intBuf.flip();
        intBuf.order(ByteOrder.LITTLE_ENDIAN);
        int n = intBuf.get() & 0xFF;
        return n;
    }

    public static int readInt() throws IOException, MainClass.IllegalReadException {
        ByteBuffer intBuf = ByteBuffer.allocate(2);
        if (MainClass.inChannel.read(intBuf) == -1) {
            throw new MainClass.IllegalReadException();
        }
        intBuf.flip();
        intBuf.order(ByteOrder.LITTLE_ENDIAN);
        int n = intBuf.getShort() & 0xFFFF;
        return n;
    }

    public static int readLong() throws IOException, MainClass.IllegalReadException {
        ByteBuffer intBuf = ByteBuffer.allocate(4);
        if (MainClass.inChannel.read(intBuf) == -1) {
            throw new MainClass.IllegalReadException();
        }
        intBuf.flip();
        intBuf.order(ByteOrder.LITTLE_ENDIAN);
        int n = intBuf.getInt();
        return n;
    }

    public static String readString() throws IOException, MainClass.IllegalReadException, MainClass.FileStructureException {
        int len = ReadCSC.readLong();
        if (len > 1800) {
            throw new MainClass.FileStructureException("Trying to read " + len + " symbols string - probable fields mismatch.");
        }
        if (len == 0) {
            return null;
        }
        ByteBuffer charBuf = ByteBuffer.allocate(len);
        if (MainClass.inChannel.read(charBuf) == -1) {
            throw new MainClass.IllegalReadException();
        }
        charBuf.flip();
        byte[] text = new byte[len];
        charBuf.get(text);
        for (int i = 0; i < len; ++i) {
            if (text[i] != 0) continue;
            len = i;
            break;
        }
        String testStr = new String(text, 0, len, MainClass.Options.encoding);
        return testStr;
    }

    public static String getFilePosition(int offset) throws IOException {
        String retValue = "";
        try {
            retValue = String.format("%6s", Long.toHexString(MainClass.inChannel.position() - (long)offset).toUpperCase()).replace(' ', '0');
        }
        catch (Exception e) {
            retValue = MainClass.inChannel == null ? "(Can't form filePosition: inChannell==null)" : "(Can't form filePosition for inChannell==" + MainClass.inChannel.toString() + "";
        }
        return retValue;
    }

    public static CSC_SoundFile getCurrentFile() {
        return currentFile;
    }

    public static void setCurrentFile(CSC_SoundFile currentFile) {
        ReadCSC.currentFile = currentFile;
    }

    public static byte[] readByteField(int size) throws IOException, MainClass.IllegalReadException {
        ByteBuffer intBuf = ByteBuffer.allocate(size);
        if (MainClass.inChannel.read(intBuf) == -1) {
            throw new MainClass.IllegalReadException();
        }
        intBuf.flip();
        return intBuf.array();
    }
}

