/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export;

import com.jcraft.oggdecoder.OggData;
import com.jcraft.oggdecoder.OggDecoder;
import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.ReadCSC;
import com.mycompany.csc_export.SM_Offset;
import com.mycompany.csc_export.SM_SoundFileInfo;
import com.mycompany.csc_export.WriteCSC;
import com.mycompany.csc_export.WriteXML;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SM_AudioChunk {
    private int dwID;
    private int dwSize;
    private byte[] aData = null;
    private byte[] unknownData;
    private int fmtSize;
    private int wAudioFormat;
    private int nNumChannels;
    private int nSampleRate;
    private int nAvgBytePerSec;
    private int nBlockAlign;
    private int nBitsPerSample;
    private int wExtraParamSize;
    private byte[] aExtraParams;
    private int dataSize;
    private byte[] dataData;
    private byte[] audioData = null;
    private boolean audioDataRead = false;
    private int junkSize;
    private int nextTag;
    private int physicalSize;
    private SM_Offset offset;
    private String audioFileName;
    private SM_SoundFileInfo subtitleText;
    public static final int RIFF = 1179011410;
    public static final int OGG = 1399285583;
    public static final int WAVE = 1163280727;
    public static final int FMT = 544501094;
    public static final int FACT = 1952670054;
    public static final int DATA = 1635017060;
    public static final int SMPL = 1819307379;
    public static final int LIST = 1414744396;
    public static final int CUE = 543520099;
    public static final int PAD = 541344080;
    public static final int JUNK = 1263424842;
    public static final int BEXT = 1954047330;
    public static final int MINF = 1718511981;
    public static final int ELMO = 1869442149;
    public static final int REGN = 1852269938;
    public static final int OVWF = 0x6677766F;
    public static final int UMID = 1684630901;

    public SM_AudioChunk(int fileId) throws MainClass.IllegalReadException, IOException, MainClass.FileStructureException {
        this.offset = new SM_Offset(fileId, (int)MainClass.inChannel.position());
        this.dwID = ReadCSC.readLong();
        if (this.dwID != 1179011410 && this.dwID != 1399285583) {
            throw new MainClass.FileStructureException("Not an audio chunk - expected RIFF or OggS tag");
        }
        this.readHeaderWAV(false);
        Map<SM_Offset, SM_AudioChunk> audioNameMap = ReadCSC.getCurrentFile().getAudioNameMap();
        audioNameMap.put(this.offset, this);
        Map<SM_Offset, SM_SoundFileInfo> audioMap = ReadCSC.getCurrentFile().getAudioMap();
        this.subtitleText = audioMap.get(this.offset);
        if (this.subtitleText != null) {
            this.subtitleText.setAudioChunk(this);
            this.audioFileName = this.subtitleText.getAudioFileName() + (this.dwID == 1179011410 ? ".wav" : ".ogg");
            this.physicalSize = 0;
            if (this.subtitleText.getSizeWAV() > this.physicalSize) {
                this.physicalSize = this.subtitleText.getSizeWAV();
            }
            if (this.subtitleText.getSizeOGG() > this.physicalSize) {
                this.physicalSize = this.subtitleText.getSizeOGG();
            }
            this.physicalSize += this.subtitleText.getDwUnknown();
        }
        MainClass.inChannel.position(this.offset.getOffset());
        if (fileId == 2) {
            this.aData = ReadCSC.readByteField(this.physicalSize);
            if (this.dwID == 1179011410 && this.wAudioFormat == 1) {
                this.audioData = this.aData;
                this.audioDataRead = true;
            }
        } else {
            MainClass.inChannel.position(MainClass.inChannel.position() + (long)this.physicalSize);
        }
    }

    public SM_AudioChunk(SM_Offset offset, SM_SoundFileInfo subtitleText) throws MainClass.IllegalReadException, IOException, MainClass.FileStructureException {
        this.offset = offset;
        if (offset.getFileID() == 2) {
            MainClass.inChannel.position(offset.getOffset());
            this.dwID = ReadCSC.readLong();
            if (this.dwID != 1179011410 && this.dwID != 1399285583) {
                throw new MainClass.FileStructureException("Not an audio chunk - expected RIFF tag");
            }
            this.readHeaderWAV(true);
            MainClass.inChannel.position(offset.getOffset());
            this.aData = ReadCSC.readByteField(this.dwSize);
        }
        if (subtitleText != null) {
            this.subtitleText = subtitleText;
            subtitleText.setAudioChunk(this);
            this.audioFileName = subtitleText.getAudioFileName();
        }
    }

    private void readHeaderWAV(boolean readDataWav) throws MainClass.IllegalReadException, IOException, MainClass.FileStructureException {
        if (this.dwID == 1179011410) {
            this.dwSize = ReadCSC.readLong();
            this.nextTag = ReadCSC.readLong();
            if (this.nextTag != 1163280727) {
                throw new MainClass.FileStructureException("Not an audio chunk - expected WAVE tag");
            }
            block5: while (MainClass.inChannel.position() < (long)(this.offset.getOffset() + this.dwSize)) {
                this.nextTag = ReadCSC.readLong();
                switch (this.nextTag) {
                    case 544501094: {
                        this.fmtSize = ReadCSC.readLong();
                        this.wAudioFormat = ReadCSC.readInt();
                        this.nNumChannels = ReadCSC.readInt();
                        this.nSampleRate = ReadCSC.readLong();
                        this.nAvgBytePerSec = ReadCSC.readLong();
                        this.nBlockAlign = ReadCSC.readInt();
                        this.nBitsPerSample = ReadCSC.readInt();
                        if (this.fmtSize < 18) continue block5;
                        this.wExtraParamSize = ReadCSC.readInt();
                        this.aExtraParams = ReadCSC.readByteField(this.wExtraParamSize);
                        continue block5;
                    }
                    case 541344080: 
                    case 543520099: 
                    case 1263424842: 
                    case 1414744396: 
                    case 1684630901: 
                    case 1718511981: 
                    case 0x6677766F: 
                    case 1819307379: 
                    case 1852269938: 
                    case 1869442149: 
                    case 1952670054: 
                    case 1954047330: {
                        this.junkSize = ReadCSC.readLong();
                        MainClass.inChannel.position(MainClass.inChannel.position() + (long)this.junkSize);
                        continue block5;
                    }
                    case 1635017060: {
                        this.dataSize = ReadCSC.readLong();
                        if (readDataWav) {
                            this.dataData = ReadCSC.readByteField(this.dataSize);
                            continue block5;
                        }
                        MainClass.inChannel.position(MainClass.inChannel.position() + (long)this.dataSize);
                        continue block5;
                    }
                }
                throw new MainClass.FileStructureException("Unfamiliar chunk tag - expected 'fmt , 'fact', 'smpl', 'LIST', 'cue ', or 'data' tag");
            }
        }
    }

    public void writeCsc() throws IOException {
        this.offset = new SM_Offset(2, WriteCSC.getFilePosition());
        WriteCSC.writeCsc(this.aData);
    }

    public int getDwSize() {
        return this.dwSize;
    }

    public SM_Offset getOffset() {
        return this.offset;
    }

    public String getAudioFileName() {
        return this.audioFileName;
    }

    public SM_SoundFileInfo getSubtitleText() {
        return this.subtitleText;
    }

    public String toString() {
        return "SM_AudioChunk{audioFileName=" + this.audioFileName + ", subtitleText=" + (this.subtitleText == null ? "null" : this.subtitleText.getSubCurrent()) + '}';
    }

    public void printXML_() {
        System.out.println("<SM_AudioChunk>");
        this.offset.printXML_();
        WriteXML.printXML("dwsize", this.dwSize);
        WriteXML.printXML("audioFileName", this.audioFileName);
        if (MainClass.Options.detailed) {
            WriteXML.printXML("fmtSize", this.fmtSize);
            WriteXML.printXML("wAudioFormat", this.wAudioFormat);
            WriteXML.printXML("nNumChannels", this.nNumChannels);
            WriteXML.printXML("nSampleRate", this.nSampleRate);
            WriteXML.printXML("nAvgBytePerSec", this.nAvgBytePerSec);
            WriteXML.printXML("nBlockAlign", this.nBlockAlign);
            WriteXML.printXML("nBitsPerSample", this.nBitsPerSample);
            WriteXML.printXML("wExtraParamSize", this.wExtraParamSize);
            if (this.wExtraParamSize > 0) {
                WriteXML.printXML("aExtraParams", this.aExtraParams);
            }
        }
        System.out.println("</SM_AudioChunk>");
    }

    public void printTXT() {
        System.out.println(this.offset.toString() + '\t' + this.offset.getFileID() + '\t' + this.offset.getOffset() + '\t' + this.dwSize + '\t' + this.audioFileName);
    }

    public byte[] getaData() {
        return this.aData;
    }

    public byte[] getAudioData() {
        if (!this.audioDataRead && this.audioData == null) {
            if (this.dwID == 1399285583) {
                try {
                    if (this.aData == null) {
                        MainClass.inChannel.position(this.offset.getOffset());
                        this.aData = ReadCSC.readByteField(this.physicalSize);
                    }
                    OggDecoder decoder = new OggDecoder();
                    OggData resultData = decoder.getData(new ByteArrayInputStream(this.aData));
                    byte[] fileContent = new byte[resultData.data.capacity()];
                    resultData.data.get(fileContent);
                    this.nNumChannels = resultData.channels;
                    this.nSampleRate = resultData.rate;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    MainClass.conFile = outputStream;
                    WriteCSC.setFilePosition(0);
                    WriteCSC.setNullWrite(false);
                    WriteCSC.writeCsc(1179011410);
                    WriteCSC.writeCsc(36 + fileContent.length);
                    WriteCSC.writeCsc(1163280727);
                    WriteCSC.writeCsc(544501094);
                    WriteCSC.writeCsc(16);
                    WriteCSC.writeCsc((short)1);
                    WriteCSC.writeCsc((short)this.nNumChannels);
                    WriteCSC.writeCsc(this.nSampleRate);
                    WriteCSC.writeCsc(12403);
                    WriteCSC.writeCsc((short)2);
                    WriteCSC.writeCsc((short)16);
                    WriteCSC.writeCsc(1635017060);
                    WriteCSC.writeCsc(fileContent.length);
                    WriteCSC.writeCsc(fileContent);
                    MainClass.conFile.close();
                    this.audioData = outputStream.toByteArray();
                }
                catch (IOException ex) {
                    Logger.getLogger(SM_AudioChunk.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (MainClass.IllegalReadException ex) {
                    Logger.getLogger(SM_AudioChunk.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.dwID == 1179011410 && this.wAudioFormat == 1) {
                try {
                    if (this.aData == null) {
                        MainClass.inChannel.position(this.offset.getOffset());
                        this.aData = ReadCSC.readByteField(this.physicalSize);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(SM_AudioChunk.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (MainClass.IllegalReadException ex) {
                    Logger.getLogger(SM_AudioChunk.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.audioData = this.aData;
            }
        }
        return this.audioData;
    }

    public int getPhysicalSize() {
        return this.physicalSize;
    }
}

