/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export;

import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.ReadCSC;
import com.mycompany.csc_export.SM_Offset;
import com.mycompany.csc_export.SM_SoundInfo;
import com.mycompany.csc_export.SM_SoundTagData;
import com.mycompany.csc_export.WriteCSC;
import com.mycompany.csc_export.WriteXML;
import java.io.IOException;

public class SM_MissionSound
implements SM_SoundTagData {
    private String strID = ReadCSC.readString();
    private SM_Offset soundInfoOffset = new SM_Offset();
    private SM_SoundInfo soundInfo;

    public SM_MissionSound() throws MainClass.IllegalReadException, MainClass.FileStructureException, IOException {
        ReadCSC.getCurrentFile().getSoundMap().put(this.soundInfoOffset, this);
        if (this.strID.endsWith("male")) {
            ReadCSC.getCurrentFile().getMissionSoundMap().put(this.strID, this);
        }
    }

    @Override
    public SM_SoundInfo getSoundInfo() {
        return this.soundInfo;
    }

    @Override
    public void setSoundInfo(SM_SoundInfo soundInfo) {
        this.soundInfo = soundInfo;
    }

    @Override
    public String getStrID() {
        return this.strID;
    }

    @Override
    public SM_Offset getSoundInfoOffset() {
        return this.soundInfoOffset;
    }

    public String toString() {
        return "SM_TaggedSound{strID=" + this.strID + '}';
    }

    @Override
    public void printXML_() {
        System.out.println("<MissionSound>");
        WriteXML.printXML("strID", this.strID);
        System.out.println("<soundInfo>");
        this.soundInfo.printXML_();
        System.out.println("</soundInfo>");
        System.out.println("</MissionSound>");
    }

    public void printTXT() {
        System.out.println(this.strID + '\t' + this.soundInfoOffset + '\t' + this.soundInfo);
    }

    @Override
    public String getVoiceID() {
        return "";
    }

    @Override
    public String getStrNoVoiceID() {
        return this.strID;
    }

    @Override
    public void writeCsc() throws IOException {
        WriteCSC.writeCsc(this.strID);
        this.soundInfo.getSubtitleTextOffset().writeCsc();
    }
}

