/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export;

import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.ReadCSC;
import com.mycompany.csc_export.WriteCSC;
import com.mycompany.csc_export.WriteXML;
import java.io.IOException;

public class SM_Offset {
    private int offset;
    private int fileID;
    private static String[] fileHeader = new String[]{"SM:", "MM:", "HD:", "D1:", "D2:", "D3:", "?6:", "?7:"};

    public SM_Offset() throws MainClass.IllegalReadException, IOException {
        int rawValue = ReadCSC.readLong();
        this.offset = rawValue & 0x1FFFFFFF;
        this.fileID = rawValue >>> 29;
    }

    public SM_Offset(int fileID, int offset) {
        this.offset = offset;
        this.fileID = fileID;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getFileID() {
        return this.fileID;
    }

    public String getString() {
        return fileHeader[this.fileID] + String.format("%08X", this.offset);
    }

    public String toString() {
        return "SM_Offset{" + this.getString() + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + this.offset;
        hash = 79 * hash + this.fileID;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SM_Offset other = (SM_Offset)obj;
        if (this.offset != other.offset) {
            return false;
        }
        return this.fileID == other.fileID;
    }

    public void printXML_() {
        System.out.println("<SM_Offset>");
        WriteXML.printXML("fileID", this.fileID);
        WriteXML.printXML("offset", this.offset);
        WriteXML.printXML("toString", this.getString());
        System.out.println("</SM_Offset>");
    }

    public void writeCsc() throws IOException {
        int rawValue = this.offset | this.fileID << 29;
        WriteCSC.writeCsc(rawValue);
    }
}

