/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export;

import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.ReadCSC;
import com.mycompany.csc_export.SM_AudioChunk;
import com.mycompany.csc_export.SM_Offset;
import com.mycompany.csc_export.SM_SoundInfo;
import com.mycompany.csc_export.WriteCSC;
import com.mycompany.csc_export.WriteXML;
import java.io.IOException;

public class SM_SoundFileInfo {
    private String audioFileName = ReadCSC.readString();
    private SM_Offset audioFileOffset = new SM_Offset();
    private int sizeWAV = ReadCSC.readLong();
    private int sizeOGG = ReadCSC.readLong();
    private int dwUnknown = ReadCSC.readLong();
    private String subEnglish = ReadCSC.readString();
    private String subFrench = ReadCSC.readString();
    private String subItalian = ReadCSC.readString();
    private String subGerman = ReadCSC.readString();
    private String subSpanish = ReadCSC.readString();
    private SM_AudioChunk audioChunk;
    private SM_SoundInfo subtitleGroup;
    private String subOriginal;

    public SM_SoundFileInfo() throws MainClass.IllegalReadException, MainClass.FileStructureException, IOException {
        ReadCSC.getCurrentFile().getAudioMap().put(this.audioFileOffset, this);
    }

    public String getAudioFileName() {
        return this.audioFileName;
    }

    public SM_Offset getAudioFileOffset() {
        return this.audioFileOffset;
    }

    public int getSizeWAV() {
        return this.sizeWAV;
    }

    public int getSizeOGG() {
        return this.sizeOGG;
    }

    public int getDwUnknown() {
        return this.dwUnknown;
    }

    public String getSubEnglish() {
        return this.subEnglish != null ? this.subEnglish : "";
    }

    public String getSubFrench() {
        return this.subFrench;
    }

    public String getSubCurrent() {
        switch (MainClass.Options.importFileLang) {
            case 0: {
                return this.getSubEnglish();
            }
            case 1: {
                return this.getSubFrench();
            }
            case 2: {
                return this.getSubItalian();
            }
            case 3: {
                return this.getSubGerman();
            }
            case 4: {
                return this.getSubSpanish();
            }
        }
        return "";
    }

    public void setSubCurrent(String line) {
        switch (MainClass.Options.importFileLang) {
            case 0: {
                this.setSubEnglish(line);
                break;
            }
            case 1: {
                this.setSubFrench(line);
                break;
            }
            case 2: {
                this.setSubItalian(line);
                break;
            }
            case 3: {
                this.setSubGerman(line);
                break;
            }
            case 4: {
                this.setSubSpanish(line);
            }
        }
    }

    public String getSubItalian() {
        return this.subItalian;
    }

    public String getSubGerman() {
        return this.subGerman;
    }

    public String getSubSpanish() {
        return this.subSpanish;
    }

    public String getSubOriginal() {
        return this.subOriginal;
    }

    public void setSubOriginal(String subOriginal) {
        this.subOriginal = subOriginal;
    }

    public void setAudioFileOffset(SM_Offset audioFileOffset) {
        this.audioFileOffset = audioFileOffset;
    }

    public void setSubEnglish(String subEnglish) {
        this.subEnglish = subEnglish;
    }

    public void setSubFrench(String subFrench) {
        this.subFrench = subFrench;
    }

    public void setSubItalian(String subItalian) {
        this.subItalian = subItalian;
    }

    public void setSubGerman(String subGerman) {
        this.subGerman = subGerman;
    }

    public void setSubSpanish(String subSpanish) {
        this.subSpanish = subSpanish;
    }

    public SM_AudioChunk getAudioChunk() {
        return this.audioChunk;
    }

    public void setAudioChunk(SM_AudioChunk audioChunk) {
        this.audioChunk = audioChunk;
    }

    public SM_SoundInfo getSubtitleGroup() {
        return this.subtitleGroup;
    }

    public void setSubtitleGroup(SM_SoundInfo subtitleGroup) {
        this.subtitleGroup = subtitleGroup;
    }

    public String toString() {
        return "SM_SoundFileInfo{audioFileName=" + this.audioFileName + ", subEnglish=" + this.subEnglish + '}';
    }

    public void printXML_() {
        System.out.println("<SoundFileInfo>");
        WriteXML.printXML("audioFileName", this.audioFileName);
        WriteXML.printXML("sizeWAV", this.sizeWAV);
        WriteXML.printXML("sizeOGG", this.sizeOGG);
        WriteXML.printXML("dwUnknown", this.dwUnknown);
        WriteXML.printXML("subEnglish", this.subEnglish);
        System.out.println("</SoundFileInfo>");
    }

    public void printTXT(int i, int j) {
        System.out.println('\t' + this.audioFileName + (this.sizeWAV > 0 ? ".WAV" : "") + (this.sizeOGG > 0 ? ".OGG" : "") + '\t' + this.audioFileOffset + '\t' + this.audioFileOffset.getOffset() + '\t' + this.getSizeWAV() + '\t' + (this.audioChunk == null ? "null" : this.audioChunk.getAudioFileName()) + '\t' + i + "/" + j + ":" + this.getSubCurrent());
    }

    public void writeCsc() throws IOException {
        WriteCSC.writeCsc(this.audioFileName);
        if (this.audioChunk == null) {
            this.audioFileOffset.writeCsc();
        } else {
            this.audioChunk.getOffset().writeCsc();
        }
        WriteCSC.writeCsc(this.sizeWAV);
        WriteCSC.writeCsc(this.sizeOGG);
        WriteCSC.writeCsc(this.dwUnknown);
        WriteCSC.writeCsc(this.subEnglish);
        WriteCSC.writeCsc(this.subFrench);
        WriteCSC.writeCsc(this.subItalian);
        WriteCSC.writeCsc(this.subGerman);
        WriteCSC.writeCsc(this.subSpanish);
    }

    public void refreshAudioChunk() {
        if (this.audioChunk == null) {
            this.audioChunk = ReadCSC.getCurrentFile().getAudioNameMap().get(this.audioFileOffset);
        }
    }
}

