/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export;

import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.ReadCSC;
import com.mycompany.csc_export.SM_AudioChunk;
import com.mycompany.csc_export.SM_Offset;
import com.mycompany.csc_export.SM_SoundFileInfo;
import com.mycompany.csc_export.SM_SoundTagData;
import com.mycompany.csc_export.WriteCSC;
import com.mycompany.csc_export.WriteXML;
import java.io.IOException;
import java.util.Map;

public class SM_SoundInfo {
    private SM_Offset subtitleTextOffset = new SM_Offset(2, (int)MainClass.inChannel.position());
    private byte[] aUnknown = ReadCSC.readByteField(45);
    private int numFiles;
    private SM_SoundFileInfo[] subtitleText;
    private String tagInfo;
    private SM_SoundTagData soundTag;
    private SM_AudioChunk audioChunk;

    public SM_SoundInfo() throws MainClass.IllegalReadException, IOException, MainClass.FileStructureException {
        if (this.aUnknown[0] == 82 && this.aUnknown[1] == 73 && this.aUnknown[2] == 70 && this.aUnknown[3] == 70) {
            this.numFiles = -1;
            MainClass.inChannel.position(this.subtitleTextOffset.getOffset());
        } else {
            this.numFiles = ReadCSC.readByte();
            this.subtitleText = new SM_SoundFileInfo[this.numFiles];
            for (int i = 0; i < this.numFiles; ++i) {
                this.subtitleText[i] = new SM_SoundFileInfo();
                this.subtitleText[i].setSubtitleGroup(this);
            }
            Map<SM_Offset, SM_SoundTagData> soundMap = ReadCSC.getCurrentFile().getSoundMap();
            this.soundTag = soundMap.get(this.subtitleTextOffset);
            if (this.soundTag != null) {
                this.tagInfo = this.soundTag.getStrID();
                this.soundTag.setSoundInfo(this);
            }
        }
    }

    public SM_Offset getSubtitleTextOffset() {
        return this.subtitleTextOffset;
    }

    public byte[] getaUnknown() {
        return this.aUnknown;
    }

    public int getNumFiles() {
        return this.numFiles;
    }

    public SM_SoundFileInfo[] getSubtitleText() {
        return this.subtitleText;
    }

    public SM_SoundTagData getSoundTag() {
        return this.soundTag;
    }

    public void setSoundTag(SM_SoundTagData soundTag) {
        this.soundTag = soundTag;
    }

    public SM_AudioChunk getAudioChunk() {
        return this.audioChunk;
    }

    public void setAudioChunk(SM_AudioChunk audioChunk) {
        this.audioChunk = audioChunk;
    }

    public String getTagInfo() {
        return this.tagInfo;
    }

    public String toString() {
        return "SM_SoundInfo{tagInfo=" + this.tagInfo + '}';
    }

    public void printXML_() {
        System.out.println("<SoundInfo>");
        WriteXML.printXML("aUnknown", this.aUnknown);
        System.out.println("<subtitleText>");
        for (int i = 0; i < this.numFiles; ++i) {
            this.subtitleText[i].printXML_();
        }
        System.out.println("</subtitleText>");
        System.out.println("</SoundInfo>");
    }

    public void printTXT(int line) {
        for (int i = 0; i < this.numFiles; ++i) {
            this.subtitleText[i].printTXT(line, i);
        }
    }

    public void writeCsc() throws IOException {
        this.subtitleTextOffset = new SM_Offset(2, WriteCSC.getFilePosition());
        WriteCSC.writeCsc(this.aUnknown);
        WriteCSC.writeCsc((byte)this.numFiles);
        for (int i = 0; i < this.numFiles; ++i) {
            this.subtitleText[i].writeCsc();
        }
    }
}

