/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export;

import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.ReadCSC;
import com.mycompany.csc_export.WriteCSC;
import java.io.IOException;

public class SM_Tag {
    private String strTagName = ReadCSC.readString();
    private int ucData = ReadCSC.readByte();
    private String[] subTags;
    private int numSubTags = ReadCSC.readByte();

    public SM_Tag() throws MainClass.IllegalReadException, MainClass.FileStructureException, IOException {
        this.subTags = new String[this.numSubTags];
        for (int i = 0; i < this.numSubTags; ++i) {
            this.subTags[i] = ReadCSC.readString();
        }
    }

    public String getStrTagName() {
        return this.strTagName;
    }

    public String getSubTag(int i) {
        return this.subTags[i];
    }

    public String toString() {
        return "SM_Tag{" + this.strTagName + ", numSubTags=" + this.numSubTags + '}';
    }

    public String[] getSubTags() {
        return this.subTags;
    }

    public int getNumSubTags() {
        return this.numSubTags;
    }

    public int getUcData() {
        return this.ucData;
    }

    public void printXML_() {
        System.out.println("<Tag Name=\"" + this.strTagName + "\">");
        for (int i = 0; i < this.numSubTags; ++i) {
            System.out.println("<SubTag>" + this.subTags[i] + "</SubTag>");
        }
        System.out.println("</Tag>");
    }

    public void printTXT() {
        System.out.println("'" + this.strTagName);
        for (int i = 0; i < this.numSubTags; ++i) {
            System.out.println("'" + this.strTagName + '.' + this.subTags[i]);
        }
    }

    public void writeCsc() throws IOException {
        WriteCSC.writeCsc(this.strTagName);
        WriteCSC.writeCsc((byte)this.ucData);
        WriteCSC.writeCsc((byte)this.numSubTags);
        for (int i = 0; i < this.numSubTags; ++i) {
            WriteCSC.writeCsc(this.subTags[i]);
        }
    }
}

