/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export;

import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.ReadCSC;
import com.mycompany.csc_export.WriteCSC;
import com.mycompany.csc_export.WriteXML;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class SM_TagRef {
    private int tag = ReadCSC.readByte();
    private int subTag = ReadCSC.readLong();
    private String tagName;
    private String subTagName;
    private static List<String> legallyBrokenTags = Arrays.asList("+groundmaterial", "+movementstate", "+pcollidetype", "+po1material", "+po1weight", "+po2material", "+po2weight");

    public SM_TagRef() throws MainClass.IllegalReadException, IOException {
        if (this.tag < 0 || this.tag >= ReadCSC.getCurrentFile().getTagsLen()) {
            this.tagName = "#" + this.tag;
            this.subTagName = "#" + this.subTag;
            System.err.println("Invalid tag " + this.getTagStr() + " at " + ReadCSC.getFilePosition(-5));
            return;
        }
        this.tagName = ReadCSC.getCurrentFile().getTags()[this.tag].getStrTagName();
        if (this.subTag >= 0 && this.subTag < ReadCSC.getCurrentFile().getTags()[this.tag].getNumSubTags()) {
            this.subTagName = ReadCSC.getCurrentFile().getTags()[this.tag].getSubTag(this.subTag);
        } else {
            this.subTagName = "#" + this.subTag;
            if (this.subTag != -1 && !legallyBrokenTags.contains(this.tagName)) {
                System.err.println("Invalid tag " + this.getTagStr() + " at " + ReadCSC.getFilePosition(-5));
            }
        }
    }

    public String getTagStr() {
        return this.tagName + (this.subTag >= 0 ? "." + this.subTagName : "");
    }

    public String toString() {
        return "SM_TagRef{" + this.getTagStr() + '}';
    }

    public void printXML_() {
        System.out.println("<TagRef>");
        WriteXML.printXML("tag", this.tag);
        WriteXML.printXML("tagName", this.tagName);
        WriteXML.printXML("subTag", this.subTag);
        WriteXML.printXML("subTagName", this.subTagName);
        System.out.println("</TagRef>");
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getSubTagName() {
        return this.subTagName;
    }

    public int getTag() {
        return this.tag;
    }

    public int getSubTag() {
        return this.subTag;
    }

    public void writeCsc() throws IOException {
        WriteCSC.writeCsc((byte)this.tag);
        WriteCSC.writeCsc(this.subTag);
    }
}

