/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export;

import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.ReadCSC;
import com.mycompany.csc_export.SM_Offset;
import com.mycompany.csc_export.SM_SoundInfo;
import com.mycompany.csc_export.SM_SoundTagData;
import com.mycompany.csc_export.SM_TagRef;
import com.mycompany.csc_export.WriteCSC;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public class SM_TaggedSound
implements SM_SoundTagData {
    private int size;
    private SM_TagRef[] tagRefs;
    private SM_Offset soundInfoOffset;
    private SM_SoundInfo soundInfo;
    private String strID = "";
    private String voiceID = "";
    private String strNoVoiceID = "";
    private String debugOffset = ReadCSC.getFilePosition(0);

    public SM_TaggedSound() throws MainClass.IllegalReadException, IOException {
        int i;
        this.size = ReadCSC.readByte();
        this.tagRefs = new SM_TagRef[this.size];
        for (i = 0; i < this.size; ++i) {
            this.tagRefs[i] = new SM_TagRef();
        }
        this.soundInfoOffset = new SM_Offset();
        if (MainClass.Options.rearrangeTags) {
            Arrays.sort(this.tagRefs, new TagComparator());
        }
        for (i = 0; i < this.size; ++i) {
            this.strID = this.strID + (i == 0 ? "" : " ") + this.tagRefs[i].getTagStr();
            if (this.tagRefs[i].getTagName().equals("+voice")) {
                this.voiceID = this.tagRefs[i].getSubTagName();
                continue;
            }
            this.strNoVoiceID = this.strNoVoiceID + (i == 0 ? "" : " ") + this.tagRefs[i].getTagStr();
        }
        ReadCSC.getCurrentFile().getSoundMap().put(this.soundInfoOffset, this);
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public SM_SoundInfo getSoundInfo() {
        return this.soundInfo;
    }

    @Override
    public void setSoundInfo(SM_SoundInfo soundInfo) {
        this.soundInfo = soundInfo;
    }

    public SM_TagRef[] getTagRefs() {
        return this.tagRefs;
    }

    @Override
    public SM_Offset getSoundInfoOffset() {
        return this.soundInfoOffset;
    }

    public void setSoundInfoOffset(SM_Offset soundInfoOffset) {
        this.soundInfoOffset = soundInfoOffset;
    }

    @Override
    public String getStrID() {
        return this.strID;
    }

    @Override
    public String getVoiceID() {
        return this.voiceID;
    }

    @Override
    public String getStrNoVoiceID() {
        return this.strNoVoiceID;
    }

    public String toString() {
        return "SM_TaggedSound{strID=" + this.strID + '}';
    }

    public String getDebugOffset() {
        return this.debugOffset;
    }

    public void printTXT() {
        System.out.print(this.debugOffset + '\t');
        for (int i = 0; i < this.size; ++i) {
            System.out.print(this.tagRefs[i].getTagStr() + ' ');
        }
        System.out.print('\t' + (this.soundInfoOffset == null ? "null" : this.soundInfoOffset.toString()) + '\t');
        System.out.println(this.soundInfo == null ? "null" : this.soundInfo.toString());
    }

    @Override
    public void printXML_() {
        System.out.println("<TaggedSound>");
        System.out.println("<Tags>");
        for (int i = 0; i < this.size; ++i) {
            this.tagRefs[i].printXML_();
        }
        System.out.println("</Tags>");
        System.out.println("<soundInfo>");
        this.soundInfo.printXML_();
        System.out.println("</soundInfo>");
        System.out.println("</TaggedSound>");
    }

    @Override
    public void writeCsc() throws IOException {
        this.debugOffset = String.format("%6s", Long.toHexString(WriteCSC.getFilePosition()).toUpperCase()).replace(' ', '0');
        WriteCSC.writeCsc((byte)this.size);
        for (int i = 0; i < this.size; ++i) {
            this.tagRefs[i].writeCsc();
        }
        this.soundInfo.getSubtitleTextOffset().writeCsc();
    }

    private class TagComparator
    implements Comparator<SM_TagRef> {
        private TagComparator() {
        }

        @Override
        public int compare(SM_TagRef t1, SM_TagRef t2) {
            return t1.getTagName().compareTo(t2.getTagName());
        }
    }
}

