/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export;

import com.mycompany.csc_export.MainClass;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class WriteCSC {
    private static int filePosition;
    private static boolean nullWrite;

    public static void writeCsc(int value) throws IOException {
        filePosition += 4;
        if (nullWrite) {
            return;
        }
        ByteBuffer intBuf = ByteBuffer.allocate(4);
        intBuf.order(ByteOrder.LITTLE_ENDIAN);
        intBuf.putInt(value);
        MainClass.conFile.write(intBuf.array());
    }

    public static void writeCsc(short value) throws IOException {
        filePosition += 2;
        if (nullWrite) {
            return;
        }
        ByteBuffer intBuf = ByteBuffer.allocate(2);
        intBuf.order(ByteOrder.LITTLE_ENDIAN);
        intBuf.putShort(value);
        MainClass.conFile.write(intBuf.array());
    }

    public static void writeCsc(byte value) throws IOException {
        ++filePosition;
        if (nullWrite) {
            return;
        }
        ByteBuffer intBuf = ByteBuffer.allocate(1);
        intBuf.order(ByteOrder.LITTLE_ENDIAN);
        intBuf.put(value);
        MainClass.conFile.write(intBuf.array());
    }

    public static void writeCsc(byte[] value) throws IOException {
        filePosition += value.length;
        if (nullWrite) {
            return;
        }
        ByteBuffer intBuf = ByteBuffer.allocate(value.length);
        intBuf.order(ByteOrder.LITTLE_ENDIAN);
        intBuf.put(value);
        MainClass.conFile.write(intBuf.array());
    }

    public static void writeCsc(String value) throws IOException {
        if (value == null || value.isEmpty()) {
            WriteCSC.writeCsc(0);
            return;
        }
        WriteCSC.writeCsc(value.length());
        filePosition += value.length();
        if (nullWrite) {
            return;
        }
        if (MainClass.Options.encoding == null) {
            MainClass.conFile.write(value.getBytes());
        } else {
            MainClass.conFile.write(value.getBytes(MainClass.Options.encoding));
        }
    }

    public static int getFilePosition() {
        return filePosition;
    }

    public static void setFilePosition(int filePosition) {
        WriteCSC.filePosition = filePosition;
    }

    public static boolean isNullWrite() {
        return nullWrite;
    }

    public static void setNullWrite(boolean nullWrite) {
        WriteCSC.nullWrite = nullWrite;
    }

    static {
        nullWrite = true;
    }
}

