/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export.con_parser;

import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.con_parser.ConEntry;
import com.mycompany.csc_export.con_parser.ReadCON;
import com.mycompany.csc_export.con_parser.TableLine;
import java.io.IOException;
import java.util.List;

public class ConBarkList
extends ConEntry {
    private int counter = ReadCON.readInt();
    private String[] barks = new String[this.counter];
    private int unknown;

    public ConBarkList(String label, int opcode) throws IOException, MainClass.FileStructureException {
        super(label, opcode);
        for (int i = 0; i < this.counter; ++i) {
            this.barks[i] = ReadCON.readString();
        }
        this.unknown = ReadCON.readInt();
        this.setName("Barks");
    }

    @Override
    public String toString() {
        String retValue = "BarkList: ";
        for (int i = 0; i < this.counter; ++i) {
            retValue = retValue + this.barks[i] + ' ';
        }
        return retValue;
    }

    @Override
    public void fillTable(List<TableLine> tableLines, int id) {
        TableLine line = new TableLine();
        line.setOpcode(this.getOpcode());
        line.setLabel(this.getLabel());
        line.setActor(this.getName());
        String barkList = "";
        for (int i = 0; i < this.barks.length; ++i) {
            if (i > 0) {
                barkList = barkList + ", ";
            }
            barkList = barkList + "\"" + this.barks[i] + "\"";
        }
        line.setText(barkList);
        tableLines.add(line);
    }
}

