/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export.con_parser;

import com.mycompany.csc_export.DemoForm;
import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.SM_SoundTagData;
import com.mycompany.csc_export.con_parser.ChoiceLine;
import com.mycompany.csc_export.con_parser.ConEntry;
import com.mycompany.csc_export.con_parser.ReadCON;
import com.mycompany.csc_export.con_parser.TableLine;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ConChoice
extends ConEntry {
    private int counter = ReadCON.readInt();
    private ChoiceLine[] choices = new ChoiceLine[this.counter];

    public ConChoice(String label, int opcode) throws IOException, MainClass.FileStructureException {
        super(label, opcode);
        for (int i = 0; i < this.counter; ++i) {
            this.choices[i] = new ChoiceLine();
        }
        this.setName("Choice");
    }

    @Override
    public String toString() {
        return "Choice: " + this.choices[0].toString();
    }

    @Override
    public void fillTable(List<TableLine> tableLines, int id) {
        TableLine line = new TableLine();
        line.setLabel(this.getLabel());
        line.setOpcode(this.getOpcode());
        line.setText("Choice");
        tableLines.add(line);
        Map<String, SM_SoundTagData> missionSoundMap = DemoForm.getSourceFile().getMissionSoundMap();
        for (int i = 0; i < this.choices.length; ++i) {
            line = new TableLine();
            if (this.choices[i].getConditions() != null && this.choices[i].getConditions().length > 0) {
                String requirements = "(";
                for (int j = 0; j < this.choices[i].getConditions().length; ++j) {
                    if (j > 0) {
                        requirements = requirements + ", ";
                    }
                    requirements = requirements + this.choices[i].getConditions()[j].toString();
                }
                requirements = requirements + ")";
                line.setActor(requirements);
            } else {
                line.setActor("");
            }
            line.setLabel(this.choices[i].getLabel());
            line.setText(this.choices[i].getText());
            line.setOpcode(this.getOpcode());
            SM_SoundTagData subtitle = missionSoundMap.get(this.choices[i].getAudioId().toLowerCase() + "_female");
            if (subtitle != null) {
                line.setAudioTag(this.choices[i].getAudioId());
                line.setLineF(subtitle.getSoundInfo().getSubtitleText()[0]);
            }
            if ((subtitle = missionSoundMap.get(this.choices[i].getAudioId().toLowerCase() + "_male")) != null) {
                line.setAudioTag(this.choices[i].getAudioId());
                line.setLineM(subtitle.getSoundInfo().getSubtitleText()[0]);
                line.setText(line.getLineM().getSubEnglish());
            }
            line.setOriginalText(this.choices[i].getText());
            line.setMap(this.getMap());
            tableLines.add(line);
        }
    }
}

