/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export.con_parser;

import com.mycompany.csc_export.DemoForm;
import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.SM_SoundTagData;
import com.mycompany.csc_export.con_parser.CONtainer;
import com.mycompany.csc_export.con_parser.ConEntry;
import com.mycompany.csc_export.con_parser.ReadCON;
import com.mycompany.csc_export.con_parser.TableLine;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ConSpeech
extends ConEntry {
    private String audioId = ReadCON.readString();
    private String text = ReadCON.readString();
    private String actor = ReadCON.readString();
    private String actorTo = ReadCON.readString();

    public ConSpeech(String label, int opcode) throws IOException, MainClass.FileStructureException {
        super(label, opcode);
        this.setName("Speech");
        if (!this.audioId.isEmpty() && !this.actor.isEmpty()) {
            CONtainer.getDialogueMap().put(this.audioId.toLowerCase(), this.actor);
        }
    }

    @Override
    public String toString() {
        return "Speech: " + this.text;
    }

    @Override
    public void fillTable(List<TableLine> tableLines, int id) {
        TableLine line = new TableLine();
        Map<String, SM_SoundTagData> missionSoundMap = DemoForm.getSourceFile().getMissionSoundMap();
        line.setLabel(this.getLabel());
        line.setText(this.text);
        line.setActorAlex(this.actor.equals("StandardPlayer"));
        line.setActor(this.decodeName(this.actor) + (!this.actor.startsWith("StandardPlayer") && !this.actorTo.startsWith("StandardPlayer") && !this.actor.equals(this.actorTo) ? " -> " + this.decodeName(this.actorTo) : ""));
        SM_SoundTagData subtitle = missionSoundMap.get(this.audioId.toLowerCase().toLowerCase() + "_female");
        line.setAudioTag(this.audioId);
        line.setOriginalText(this.text);
        if (subtitle != null) {
            line.setLineF(subtitle.getSoundInfo().getSubtitleText()[0]);
        }
        if ((subtitle = missionSoundMap.get(this.audioId.toLowerCase() + "_male")) != null) {
            line.setLineM(subtitle.getSoundInfo().getSubtitleText()[0]);
            line.setText(line.getLineM().getSubEnglish());
            line.setMap(this.getMap());
        }
        tableLines.add(line);
    }
}

