/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export.con_parser;

import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.con_parser.Con04;
import com.mycompany.csc_export.con_parser.Con07;
import com.mycompany.csc_export.con_parser.Con0A;
import com.mycompany.csc_export.con_parser.ConBarkList;
import com.mycompany.csc_export.con_parser.ConChoice;
import com.mycompany.csc_export.con_parser.ConEnd;
import com.mycompany.csc_export.con_parser.ConEntry;
import com.mycompany.csc_export.con_parser.ConGoal;
import com.mycompany.csc_export.con_parser.ConGoto;
import com.mycompany.csc_export.con_parser.ConItem;
import com.mycompany.csc_export.con_parser.ConLogic;
import com.mycompany.csc_export.con_parser.ConNote;
import com.mycompany.csc_export.con_parser.ConSetGoal;
import com.mycompany.csc_export.con_parser.ConSpeech;
import com.mycompany.csc_export.con_parser.LogicEntry;
import com.mycompany.csc_export.con_parser.ReadCON;
import com.mycompany.csc_export.con_parser.TableLine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Conversation {
    private int id;
    private String map;
    private String name;
    private String comment;
    private String actor;
    private List<ConEntry> entries = new ArrayList<ConEntry>();
    private List<TableLine> tableLines = new ArrayList<TableLine>();
    private List<LogicEntry> conditions = new ArrayList<LogicEntry>();

    public Conversation(String map, String address) throws IOException, MainClass.FileStructureException {
        int i;
        this.map = map;
        long addressHex = Long.parseUnsignedLong(address, 16);
        if (MainClass.inChannel.position() > 0L && MainClass.inChannel.position() != addressHex - 8L) {
            System.err.println("Incorrectly read conditions");
        }
        MainClass.inChannel.position(addressHex - 4L);
        this.id = ReadCON.readInt();
        this.name = ReadCON.readString();
        this.comment = ReadCON.readString();
        String dummyString = ReadCON.readString();
        String savedLabel = null;
        this.actor = ReadCON.readString();
        int counter = ReadCON.readInt();
        counter = ReadCON.readInt();
        counter = ReadCON.readInt();
        counter = ReadCON.readInt();
        counter = ReadCON.readInt();
        block17: for (i = 0; i < counter; ++i) {
            String label = ReadCON.readString();
            if (label.isEmpty() && savedLabel != null) {
                label = savedLabel;
                savedLabel = null;
            }
            int opcode = ReadCON.readInt();
            ConEntry line = null;
            switch (opcode) {
                case 0: {
                    line = new ConSpeech(label, opcode);
                    break;
                }
                case 1: {
                    line = new ConGoto(label, opcode);
                    break;
                }
                case 2: {
                    line = new ConBarkList(label, opcode);
                    break;
                }
                case 3: {
                    line = new ConEnd(label, opcode);
                    break;
                }
                case 4: 
                case 9: {
                    line = new Con04(label, opcode);
                    if (label.isEmpty()) continue block17;
                    savedLabel = label;
                    continue block17;
                }
                case 5: {
                    line = new ConChoice(label, opcode);
                    break;
                }
                case 7: {
                    line = new Con07(label, opcode);
                    if (label.isEmpty()) continue block17;
                    savedLabel = label;
                    continue block17;
                }
                case 10: {
                    line = new Con0A(label, opcode);
                    if (label.isEmpty()) continue block17;
                    savedLabel = label;
                    continue block17;
                }
                case 11: {
                    line = new ConGoal(label, opcode);
                    break;
                }
                case 12: {
                    line = new ConNote(label, opcode);
                    break;
                }
                case 13: {
                    line = new ConItem(label, opcode);
                    break;
                }
                case 14: {
                    line = new ConSetGoal(label, opcode);
                    break;
                }
                case 17: {
                    line = new ConLogic(label, opcode);
                    ++counter;
                    if (!line.getLabel().isEmpty() || savedLabel == null) break;
                    line.setLabel(savedLabel);
                    savedLabel = null;
                    break;
                }
                default: {
                    throw new MainClass.FileStructureException("Invalid opcode");
                }
            }
            line.setMap(map);
            this.entries.add(line);
        }
        counter = ReadCON.readInt();
        if (counter != 0) {
            throw new MainClass.FileStructureException("Unrecognized structure found");
        }
        counter = ReadCON.readInt();
        if (counter > 20) {
            throw new MainClass.FileStructureException("Unrecognized structure found");
        }
        for (i = 0; i < counter; ++i) {
            try {
                this.conditions.add(new LogicEntry());
                continue;
            }
            catch (Exception e) {
                System.err.println("Error found");
            }
        }
    }

    public String getMap() {
        return this.map;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public String getActor() {
        return this.actor;
    }

    public List<ConEntry> getEntries() {
        return this.entries;
    }

    public List<TableLine> getTableLines() {
        this.tableLines.clear();
        for (ConEntry item : this.entries) {
            item.fillTable(this.tableLines, this.id);
        }
        return this.tableLines;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }

    public List<LogicEntry> getConditions() {
        return this.conditions;
    }
}

