/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export.con_parser;

import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.con_parser.ReadCON;
import java.io.IOException;

public class KTagCondition {
    private String type = ReadCON.readString();
    private String param;
    private String relation = "=";
    private String value;
    private KTagCondition[] logicParams;
    private int logicType;
    private static String[] relationValues = new String[]{"", "", "<", "", ">", ">=", "", ""};

    public KTagCondition() throws IOException, MainClass.FileStructureException {
        int dummy = ReadCON.readInt();
        switch (this.type) {
            case "kTCT_CreditCheck": {
                this.param = this.type.substring(5);
                String dummyString = ReadCON.readString();
                dummy = ReadCON.readInt();
                this.relation = relationValues[dummy];
                dummy = ReadCON.readKInt();
                this.value = "" + dummy;
                break;
            }
            case "kTCT_EventFlagSet": 
            case "kTCT_FlagSet": {
                this.param = ReadCON.readKString();
                this.value = "" + ReadCON.readKBoolean();
                break;
            }
            case "kTCT_GlobalIntQuery": {
                this.param = "[G]" + ReadCON.readKString();
                String dummyString = ReadCON.readString();
                dummy = ReadCON.readInt();
                this.relation = relationValues[dummy];
                this.value = "" + ReadCON.readKInt();
                break;
            }
            case "kTCT_QueryGIntRelateToGInt": {
                this.param = "[G]" + ReadCON.readKString();
                String dummyString = ReadCON.readString();
                dummy = ReadCON.readInt();
                this.relation = relationValues[dummy];
                this.value = "[G]" + ReadCON.readKString();
                break;
            }
            case "kTCT_LogicOperator": {
                String dummyString = ReadCON.readString();
                this.logicType = ReadCON.readChar();
                dummy = ReadCON.readInt();
                this.logicParams = new KTagCondition[dummy];
                for (int i = 0; i < dummy; ++i) {
                    this.logicParams[i] = new KTagCondition();
                }
                break;
            }
        }
    }

    public String toString() {
        if (this.type.equals("kTCT_LogicOperator")) {
            String retValue = "(";
            for (int i = 0; i < this.logicParams.length; ++i) {
                if (i > 0) {
                    retValue = retValue + (this.logicType > 0 ? " OR " : " AND ");
                }
                retValue = retValue + this.logicParams[i].toString();
            }
            retValue = retValue + ")";
            return retValue;
        }
        return this.param + " " + this.relation + " " + this.value;
    }
}

