/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export.con_parser;

import com.mycompany.csc_export.MainClass;
import com.mycompany.csc_export.con_parser.ReadCON;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;

public class LogicEntry {
    private int type = ReadCON.readInt();
    private String flag;
    private boolean state;
    private int logicType;
    private int counter;
    private LogicEntry[] components;
    private static String[] logicTypes = new String[]{"AND", "OR", "NOT"};

    LogicEntry() throws IOException, MainClass.FileStructureException {
        switch (this.type) {
            case 0: {
                this.logicType = ReadCON.readInt();
                this.counter = ReadCON.readInt();
                if (this.counter > 20) {
                    throw new MainClass.FileStructureException("trying to read more than 20 logic conditions; probably wrong");
                }
                this.components = new LogicEntry[this.counter];
                for (int i = 0; i < this.counter; ++i) {
                    this.components[i] = new LogicEntry();
                }
                break;
            }
            case 1: {
                this.flag = ReadCON.readString();
                this.state = ReadCON.readBoolean();
                break;
            }
            default: {
                throw new MainClass.FileStructureException("Unknown LogicEntry type");
            }
        }
    }

    public String toString() {
        if (this.type == 1) {
            return this.flag + "=" + this.state;
        }
        String retString = " " + this.logicType + " (";
        for (int i = 0; i < this.counter; ++i) {
            if (i > 0) {
                retString = retString + ", ";
            }
            retString = retString + this.components[i].toString();
        }
        retString = retString + ")";
        return retString;
    }

    public DefaultMutableTreeNode generateNode() {
        if (this.type == 1) {
            return new DefaultMutableTreeNode(this.flag + "=" + this.state);
        }
        DefaultMutableTreeNode resultNode = new DefaultMutableTreeNode(logicTypes[this.logicType]);
        for (int i = 0; i < this.counter; ++i) {
            DefaultMutableTreeNode componentNode = this.components[i].generateNode();
            resultNode.add(componentNode);
        }
        return resultNode;
    }
}

