/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export.con_parser;

import com.mycompany.csc_export.MainClass;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ReadCON {
    public static int readInt() throws IOException {
        ByteBuffer intBuf = ByteBuffer.allocate(4);
        if (MainClass.inChannel.read(intBuf) == -1) {
            throw new IOException();
        }
        intBuf.flip();
        intBuf.order(ByteOrder.LITTLE_ENDIAN);
        int n = intBuf.getInt();
        return n;
    }

    public static int readChar() throws IOException {
        ByteBuffer intBuf = ByteBuffer.allocate(2);
        if (MainClass.inChannel.read(intBuf) == -1) {
            throw new IOException();
        }
        intBuf.flip();
        intBuf.order(ByteOrder.LITTLE_ENDIAN);
        short n = intBuf.getShort();
        return n;
    }

    public static int readByte() throws IOException {
        ByteBuffer intBuf = ByteBuffer.allocate(1);
        if (MainClass.inChannel.read(intBuf) == -1) {
            throw new IOException();
        }
        intBuf.flip();
        intBuf.order(ByteOrder.LITTLE_ENDIAN);
        byte n = intBuf.get();
        return n;
    }

    public static float readFloat() throws IOException {
        ByteBuffer intBuf = ByteBuffer.allocate(4);
        if (MainClass.inChannel.read(intBuf) == -1) {
            throw new IOException();
        }
        intBuf.flip();
        intBuf.order(ByteOrder.LITTLE_ENDIAN);
        float n = intBuf.getFloat();
        return n;
    }

    public static String readString() throws IOException, MainClass.FileStructureException {
        int ch;
        String dataString = "";
        while ((ch = ReadCON.readChar()) != 0) {
            if (ch < 32 || ch > 127) {
                System.err.println(String.format("%08X:\t", MainClass.inChannel.position()));
                throw new MainClass.FileStructureException("Non-character symbol passed to String");
            }
            dataString = dataString + Character.toString((char)ch);
        }
        return dataString;
    }

    public static boolean readBoolean() throws IOException {
        int i = ReadCON.readInt();
        return i > 0;
    }

    public static String readKString() throws IOException, MainClass.FileStructureException {
        String dummyString = ReadCON.readString();
        if (!(dummyString.equals("kTPT_String") || dummyString.equals("kTPT_GlobalInt") || dummyString.equals("kTPT_Flag"))) {
            throw new MainClass.FileStructureException("Invalid kTag");
        }
        dummyString = ReadCON.readString();
        return dummyString;
    }

    public static int readKInt() throws IOException, MainClass.FileStructureException {
        String dummyString = ReadCON.readString();
        if (!dummyString.equals("kTPT_Int")) {
            throw new MainClass.FileStructureException("Invalid kTag");
        }
        int dummyInt = ReadCON.readInt();
        dummyInt = ReadCON.readInt();
        return dummyInt;
    }

    public static float readKFloat() throws IOException, MainClass.FileStructureException {
        String dummyString = ReadCON.readString();
        if (!dummyString.equals("kTPT_Float")) {
            throw new MainClass.FileStructureException("Invalid kTag");
        }
        int dummyInt = ReadCON.readInt();
        float dummyFloat = ReadCON.readFloat();
        return dummyFloat;
    }

    public static boolean readKBoolean() throws IOException, MainClass.FileStructureException {
        String dummyString = ReadCON.readString();
        if (!dummyString.equals("kTPT_Bool")) {
            throw new MainClass.FileStructureException("Invalid kTag");
        }
        int dummyInt = ReadCON.readInt();
        boolean dummyBoolean = ReadCON.readBoolean();
        return dummyBoolean;
    }
}

