/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.csc_export.coneditform;

import com.mycompany.csc_export.con_parser.TableLine;
import com.mycompany.csc_export.coneditform.ConTableModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class ConTableCellRenderer
implements TableCellRenderer {
    private static Color speechAlex = new Color(204, 255, 252);
    private static Color speechChoice = new Color(255, 252, 216);
    private static Color speechError = new Color(255, 181, 188);
    private static Color speechNone = new Color(234, 234, 234);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTextField editor = new JTextField();
        if (value != null) {
            editor.setText(value.toString());
        }
        if (column == 0) {
            editor.setFont(editor.getFont().deriveFont(1));
        }
        TableLine line = ((ConTableModel)table.getModel()).getTableLines().get(row);
        int opcode = line.getOpcode();
        switch (opcode) {
            case 0: {
                if (line.isActorAlex()) {
                    editor.setBackground(speechAlex);
                }
                if (line.getAudioTag().isEmpty() || line.getLineF().getAudioChunk() != null && line.getLineM().getAudioChunk() != null) break;
                editor.setBackground(speechError);
                break;
            }
            case 5: {
                editor.setBackground(speechChoice);
                if (!(line.getAudioTag().isEmpty() || line.getLineF().getAudioChunk() != null && line.getLineM().getAudioChunk() != null || line.getText().equalsIgnoreCase("Choice"))) {
                    editor.setBackground(speechError);
                }
                if (!line.getText().equalsIgnoreCase("Choice")) break;
                editor.setFont(editor.getFont().deriveFont(1));
                break;
            }
            default: {
                editor.setBackground(speechNone);
                if (column <= 0 || opcode == 100) break;
                editor.setFont(editor.getFont().deriveFont(2));
            }
        }
        editor.setBorder(BorderFactory.createEmptyBorder());
        if (isSelected) {
            editor.setBackground((Color)UIManager.get("Table.selectionBackground"));
        }
        return editor;
    }
}

