//============================================
// CozRPGWeapon
//============================================
Class CozRPGWeapon extends DeusExWeapon;

Var() bool bInShop;
Var() int CozWeaponCost;
Var() string RealItemName;
Var bool bCozHandToHand;
Var bool bIsEnhanced;

simulated function bool TestMPBeltSpot(int BeltSpot)
{
	return( (BeltSpot >= 1) && (BeltSpot <=9) );
}

function BringUp()
{
	bInShop=False;
	ItemName=RealItemName;
	Super.BringUp();
}

auto state Pickup
{
	function Frob (Actor Frobber, Inventory frobWith)
	{
		if (ClassIsChildOf(Frobber.class,class'DeusExPlayer'))
		{
			if(bInShop == True)
			{
				if(DeusExPlayer(Frobber).Credits >= CozWeaponCost)
				{
					DeusExPlayer(Frobber).Credits-=CozWeaponCost;
					DeusExPlayer(Frobber).ClientMessage("|p7You bought the"@RealItemName@"for c("$CozWeaponCost$")");
					Super.Frob(Frobber,frobWith);
				}
				else
				{
					DeusExPlayer(Frobber).ClientMessage("|p2You don't have "$CozWeaponCost$" Credits!");
				}
			}
			else
			{
				Super.Frob(Frobber,frobWith);
				ItemName=RealItemName;
			}
		}
	}
}

function Tick(float deltaTime)
{
	if (DeusExPlayer(Owner) != None)
	{
		if(bCozHandToHand == True)
		{
			if(bIsEnhanced == False)
			{
				if(DeusExPlayer(Owner).WarrenSlot == 401)
				{
					HitDamage*=1.5;
					bIsEnhanced=True;
				}
				else
				{
					HitDamage=mpHitDamage;
				}
			}
		}

		if((DeusExPlayer(Owner).WarrenSlot == 400) && (bIsEnhanced == True))
		{
			HitDamage/=1.5;
			bIsEnhanced=False;
		}
	}

	Super.Tick(deltaTime);
}

//function Fire(float Value) //Cozmo: looool (old system before I made police)
//{
//	local AntiSpawnKillTurret AntiSK;
//
//	foreach VisibleActors(class'AntiSpawnKillTurret', AntiSK, 100 * 16)
//	{
//		AntiSK.SKER = DeusExPlayer(Owner);
//	}
//
//	Super.Fire(value);
//}

defaultproperties
{
     bInShop=True
     CozWeaponCost=60
     RealItemName="DEFAULT WEAPON NAME!"
}
