//==========================================================
// Allianceshandler
//
// Actually, after a beta, it turns out that your alliance
// changing during MP doesn't seem to do anything. SO that 
// makes this class completely redundant. Leaving it as source
// code + because I am paranoid stuff still relies on it.
//==========================================================
Class AlliancesHandler extends Actor;

Var Name PrevAlliance[20];
Var DeusExPlayer PrevAllianceGuy[20];
var PoliceCrimeMon PCMM;

function BeginPlay()
{
	local PoliceCrimeMon PCM;

	Super.BeginPlay();

	SetTimer(10.0, true);

	foreach AllActors(class'PoliceCrimeMon',PCM)
	{
		PCMM = PCM;
	}
}

function GiveBackAlliance(DeusExPlayer P)
{
	local int i;

	for (i=1; i<20; i++)
	{
		if(PrevAllianceGuy[i] == P)
		{
			P.Alliance = PrevAlliance[i];
			PrevAllianceGuy[i] = None;
			return;
		}
	}
}

function NewAlliance(DeusExPlayer P, Name NewAlliance)
{
	local int i;

	for (i=1; i<20; i++)
	{
		if(PrevAllianceGuy[i] == P)
		{
			PrevAlliance[i] = NewAlliance;
		}
	}

	P.Alliance = NewAlliance;
}

function HandleAlliance(DeusExPlayer P, Name NAlliance)
{
	local int i;
	local int k;
	local PPolicePistol PPP;

	if(P.Alliance == NAlliance) //They wouldn't even react if you used an uzi before this
	{
		return;
	}

	for (k=1; k<20; k++)
	{
		if(PrevAllianceGuy[k] == P) //First, make sure player isn't already marked. Don't wanna override old alliance
		{
			if(NAlliance == 'Criminal') //...Except for cops. They need immediate / more permanent reaction.
			{
				if(PCMM.PlayerCop[k] == P)
				{
					PCMM.PlayerCop[k] = None;
					P.ClientMessage("|p2You have lost your job as a cop for commiting crime.");

					if(P.MultiSkins[2]==Texture'DeusExCharacters.Skins.CopTex1')
					{
						P.MultiSkins[2]=Texture'DeusExCharacters.Skins.Male3Tex1';
					}

					foreach AllActors(Class'PPolicePistol', PPP)
					{
						if(PPP.Owner == P)
						{
							PPP.Destroy();
						}
					}
				}

				P.Alliance = 'Criminal';
			}

			return;
		}
	}

	for (i=1; i<20; i++)
	{
		if(PrevAllianceGuy[i] == None)
		{
			if((PCMM.PlayerCop[i] == P) && (NAlliance == 'Criminal'))
			{
				PCMM.PlayerCop[i] = None;
				P.ClientMessage("|p2You have lost your job as a cop for commiting crime.");

				if(P.MultiSkins[2]==Texture'DeusExCharacters.Skins.CopTex1')
				{
					P.MultiSkins[2]=Texture'DeusExCharacters.Skins.Male3Tex1';
				}

				foreach AllActors(Class'PPolicePistol', PPP)
				{
					if(PPP.Owner == P)
					{
						PPP.Destroy();
					}
				}
			}

			PrevAllianceGuy[i] = P;
			PrevAlliance[i] = P.Alliance;
			P.Alliance = NAlliance;
			return;
		}
	}
}

function Timer()
{
	local NewScriptedPawnTest NPC;
	local int k;
	local int testint;

	for (k=1; k<20; k++)
	{
		if(PrevAllianceGuy[k] != None)
		{
			foreach AllActors(class'NewScriptedPawnTest',NPC)
			{
				if(NPC.NNAlliance == PrevAllianceGuy[k].Alliance)
				{
					if(VSize(PrevAllianceGuy[k].Location-NPC.Location) < 1000) //Test distance. Should make a variable in NPC.
					{
						testint ++; //npcs in proximity you
					}
				}
			}

			if(testint == 0) //Doing it this way so it happens *after* the NPC foreach loop
			{
					if(PrevAllianceGuy[k].Alliance != 'Criminal') //It would be too easy for criminals otherwise
					{
						PrevAllianceGuy[k].Alliance = PrevAlliance[k];
						PrevAllianceGuy[k] = None;
					}

					testint = 0;
			}
		}
	}
}

defaultproperties
{
     bHidden=True
}
