//=============================================================================
// ComputerScreenEmailNew - Cozmo
//=============================================================================
class ComputerScreenEmailNEW expands ComputerScreenEmail;

struct TextEmailInfo 
{
	var Name   emailName;
	var String emailSubject;
	var String emailFrom;
	var String emailTo;
	var String emailContent;
};

var transient TextEmailInfo emailInfo[4];

// ----------------------------------------------------------------------
// SetCompOwner()
// ----------------------------------------------------------------------
function SetCompOwner(ElectronicDevices newCompOwner)
{
	local String emailName;
	local int i;
	local int emailInfoIndex;
	local int rowId;
	local CozMPPC mppc;
	local DeusExPlayer player;

	player = DeusExPlayer(root.parentPawn);

	emailIndex = -1;

	foreach AllObjects(class'CozMPPC',mppc)
	{
		if(mppc.Owner == player)
		{
			for (i=0; i<4; i++)
			{
				emailInfo[i].emailName = mppc.emailInform[i].emailName;
				emailInfo[i].emailSubject = mppc.emailInform[i].emailSubject;
				emailInfo[i].emailFrom = mppc.emailInform[i].emailFrom;
				emailInfo[i].emailTo = mppc.emailInform[i].emailTo;
				emailInfo[i].emailContent = mppc.emailInform[i].emailContent;

				if(emailInfo[i].emailSubject != "")
				{
					emailIndex += 1;
				}
			}
		}
	}


		//emailInfoIndex = 1; //Hax?

		// Now populate our list
		for(emailInfoIndex=0; emailInfoIndex<=emailIndex; emailInfoIndex++)
			lstEmail.AddRow(emailInfo[emailInfoIndex].emailFrom $ ";" $ 
			                emailInfo[emailInfoIndex].emailSubject $ ";" $ 
							emailInfoIndex);

		// Select the first row
		rowId = lstEmail.IndexToRowId(0);
		lstEmail.SetRow(rowId, True);

		// No Email, so just print a "No Email Today!" message // YES email.
		//winEmail.SetText(NoEmailTodayText);
		//winEmail.SetTextAlignments(HALIGN_Center, VALIGN_Center);
	//}

		winStatus.SetText("Cozmo:GlobalNode:" $ Computers(compOwner).GetNodeAddress() $ "/" $ ComputerNodeFunctionLabel);
}

event bool ListSelectionChanged(window list, int numSelections, int focusRowId)
{
	local int emailInfoIndex;

	emailInfoIndex = Int(lstEmail.GetField(focusRowId, 2));

	// Generate the email header
	winEmailFrom.SetText(emailInfo[emailInfoIndex].emailFrom);
	winEmailTo.SetText(emailInfo[emailInfoIndex].emailTo);
	winEmailSubject.SetText(emailInfo[emailInfoIndex].emailSubject);

	winEmail.SetText(emailInfo[emailInfoIndex].emailContent); //Cozmo: Emails need content...

	winEmailCCHeader.Hide();
}

defaultproperties
{
     NoEmailTodayText="No Email Today TEST!!!!! (To see if my modified window's actually being called*) #2"
}
