//=============================================================================
// CozCop
//=============================================================================
class CozCop extends NewScriptedPawnTest;

function Carcass SpawnCarcass()
{
	IsKilled(Enemy);

	return Super.SpawnCarcass();
}

function IsKilled(pawn Killer)
{
	local PoliceCrimeMon PCM;
	local int i;
	local int k;
	local CozWeaponPistol2 CWP;
	local CozCopBaton CCB;

	foreach AllActors(class'CozWeaponPistol2',CWP)
	{
		if(CWP.Owner == Self)
		{
			CWP.Destroy();
		}
	}

	foreach AllActors(class'CozCopBaton',CCB)
	{
		if(CCB.Owner == Self)
		{
			CCB.Destroy();
		}
	}

	if (Killer.IsA('Human'))
	{
		Human(Killer).ClientMessage("|p7 50 credits found on the cop's body.");
		Human(Killer).Credits += 50;
		Human(Killer).SkillPointsAdd(300);

		foreach AllActors(class'PoliceCrimeMon',PCM)
		{
			for (i=1; i<21; i++)
			{
				if(Human(Killer) == PCM.Criminal[i])
				{
					if(PCM.CriminalLevel[i] >= 1)
					{
						PCM.CriminalLevel[i] += 2;
						//Human(Killer).Alliance = 'Criminal'; //Cozmo: If it somehow isn't already, like I found in beta sometimes
						AH.HandleAlliance(DeusExPlayer(Killer), NNAlliance);
						Human(Killer).ClientMessage("|p2Current criminal level: "$PCM.CriminalLevel[i]);
						return;
					}
				}
			}

			for (k=1; k<21; k++)
			{
				if(PCM.Criminal[k] == None)
				{
					PCM.Criminal[k] = Human(Killer);
					PCM.CriminalLevel[k] += 2;
					Human(Killer).ClientMessage("|p2The police are angry with you. Current criminal level: "$PCM.CriminalLevel[k]);
					BroadcastMessage("|P2"$Human(Killer).PlayerReplicationInfo.PlayerName$" is now wanted by the police.");
					//Human(Killer).Alliance = 'Criminal';
					AH.HandleAlliance(DeusExPlayer(Killer), NNAlliance);
					return;
				}
			}
		}
	}
}

defaultproperties
{
     NNAlliance=Criminal
     Alliance=Cop
     InitialAlliances(0)=(AllianceName=Criminal,AllianceLevel=-1.000000,bPermanent=True)
     InitialAlliances(1)=(AllianceName=LumPathC,AllianceLevel=-1.000000,bPermanent=True)
     InitialAlliances(2)=(AllianceName=RarrowC,AllianceLevel=-1.000000,bPermanent=True)
     InitialAlliances(3)=(AllianceName=Player,AllianceLevel=1.000000,bPermanent=True) //Sorry. Silly DXMP.
     bCAggressive=False
     HealthHead=100
     HealthTorso=100
     HealthLegLeft=100
     HealthLegRight=100
     HealthArmLeft=100
     HealthArmRight=100
     Orders=Wandering
     WalkingSpeed=0.300000
     BaseAssHeight=-23.000000
     InitialInventory(1)=(Inventory=Class'RPGMasterTest.CozWeaponPistol2')
     InitialInventory(2)=(Inventory=Class'RPGMasterTest.CozCopBaton')
     InitialInventory(3)=(Inventory=Class'RPGMasterTest.AmmoCredits')
     AttitudeToPlayer=ATTITUDE_Hate
     walkAnimMult=1.200000
     GroundSpeed=200.000000
     WaterSpeed=240.000000
     AirSpeed=144.000000
     BaseEyeHeight=36.000000
     DrawType=DT_Mesh
     CarcassType=Class'DeusEx.CopCarcass'
     WalkingSpeed=0.296000
     walkAnimMult=0.750000
     GroundSpeed=200.000000
     Mesh=LodMesh'DeusExCharacters.GM_DressShirt'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.CopTex0'
     MultiSkins(1)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.CopTex0'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.CopTex2'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.CopTex0'
     MultiSkins(5)=Texture'DeusExCharacters.Skins.CopTex1'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.FramesTex2'
     MultiSkins(7)=Texture'DeusExCharacters.Skins.LensesTex2'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     BindName="Cop"
     FamiliarName="Cop"
     UnfamiliarName="Cop"
}