//========================================================================
// CozDataCube - Cozmo
//
// Created to work on multiplayer and from variables rather than
// the Parser.
//
// Note to self - see InformationDevices.uc and HUDInformationDisplay.uc
//========================================================================
Class CozDataCube extends DataCube;

Var() String DataCubeText;
var() Color colInfoText;

function CreateInfoWindow() //Cozmo: SO much cleaner without Parser stuff
{
	local DeusExRootWindow rootWindow;

	rootWindow = DeusExRootWindow(aReader.rootWindow);
			    
	if (aReader != None)
	{
		infoWindow = rootWindow.hud.ShowInfoWindow();
		infoWindow.ClearTextWindows();
		CozWindowStuff();
	}
}

function CozWindowStuff()
{
	// Make sure we have a text window to operate on.
	if (winText == None)
	{
		winText = infoWindow.AddTextWindow();
	}

	WinText.SetText(DataCubeText);
	WinText.SetTextColor(colInfoText);
	WinText.SetWordWrap(True);
	WinText.SetTextAlignments(HALIGN_Left, VALIGN_Top);
//	WinText.SetSize(300, 260);
}

defaultproperties
{
     DataCubeText="No entries have been found on this datacube."
     colInfoText=(R=250,G=250,B=250)
}
