//=============================================================================
// ThugMale.
//=============================================================================
class DistressedWomanThug1 extends NewScriptedPawnTest;

var PoliceCrimeMon PCM;
Var AlliancesHandler AH;

function BeginPlay()
{
	local PoliceCrimeMon PCMM;
	local AlliancesHandler AHH;

	foreach AllActors(Class'PoliceCrimeMon',PCMM)
	{
		PCM=PCMM;
	}

	foreach AllActors(Class'AlliancesHandler',AHH)
	{
		AH=AHH;
	}

	Super.BeginPlay();
}

function Carcass SpawnCarcass()
{
	local int i;
	local int k;

	if(Enemy.IsA('Human'))
	{
		for (i=1; i<21; i++)
		{
			if(Human(Enemy) == PCM.PlayerCop[i])
			{
				if(PCM.CriminalLevel[i] >= 1)
				{
					return Super.SpawnCarcass(); //If player's already a cop, nvm. Stop here.
				}
			}
		}

		for (k=1; k<21; k++)
		{
			if(PCM.PlayerCop[k] == None)
			{
				PCM.PlayerCop[k] = Human(Enemy);
				AH.NewAlliance(DeusExPlayer(Enemy), 'Cop');
				DeusExPlayer(Enemy).Clientmessage("|p2Good job. Return to the van to complete your initiation.");
				return Super.SpawnCarcass();
			}
		}
	}
}

defaultproperties
{
     NNAlliance=Player
     bRespawning=True
     InitialAlliances(0)=(AllianceName=Rarrow,AllianceLevel=-1.000000,bPermanent=True)
     InitialAlliances(1)=(AllianceName=RarrowC,AllianceLevel=-1.000000,bPermanent=True)
     InitialAlliances(2)=(AllianceName=Cop,AllianceLevel=-1.000000,bPermanent=True)
     InitialAlliances(3)=(AllianceName=LumPath,AllianceLevel=1.000000,bPermanent=True)
     InitialAlliances(4)=(AllianceName=LumPathC,AllianceLevel=-1.000000,bPermanent=True)
     InitialAlliances(5)=(AllianceName=AggPlayer,AllianceLevel=-1.000000,bPermanent=True)
     InitialAlliances(6)=(AllianceName=Player,AllianceLevel=-1.000000,bPermanent=True)
     CarcassType=Class'DeusEx.ThugMaleCarcass'
     WalkingSpeed=0.213333
     BaseAssHeight=-23.000000
     InitialInventory(0)=(Inventory=Class'DeusEx.WeaponCrowbar')
     GroundSpeed=180.000000
     Mesh=LodMesh'DeusExCharacters.GM_Trench'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.ThugMaleTex0'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.ThugMaleTex2'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.ThugMaleTex3'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.ThugMaleTex0'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.ThugMaleTex1'
     MultiSkins(5)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(6)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(7)=Texture'DeusExItems.Skins.BlackMaskTex'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     BindName="Thug"
     FamiliarName="Thug"
     UnfamiliarName="Thug"
}
