//=============================================================================
// Follow Player Test
//=============================================================================
class FollowTest extends PaulDenton;

Var DeusExPlayer DXP;
var bool bRunningTo;

function BeginPlay()
{
	SetTimer(1.0, true);

	Super.BeginPlay();
}

function Timer()
{
	if(DXP != None)
	{
		if(VSize(Location-DXP.Location) < 200)
		{
			gotoState('Standing');
		}
		else
		{
			GetMoving();
		}
	}
}

function Frob(Actor Frobber, Inventory frobWith) 
{
	if(DXP != DeusExPlayer(Frobber))
	{
		DeusExPlayer(Frobber).ClientMessage("This pawn is now following you.");
		DXP = DeusExPlayer(Frobber);
		GetMoving();
	}
}

function GetMoving()
{
	if(DXP != None)
	{
		if(VSize(Location-DXP.Location) > 300)
		{
			bRunningTo = True;
			gotoState('Follow');
		}
		else if(VSize(Location-DXP.Location) > 200)
		{
			bRunningTo = False;
			gotoState('Follow');
		}
		else
		{
			gotoState('Standing');
		}
	}
}

State Follow
{
	function SetFall()
	{
		StartFalling('Patrolling', 'ContinuePatrol');
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		Global.HitWall(HitNormal, Wall);
		CheckOpenDoor(HitNormal, Wall);
	}
	
	function AnimEnd()
	{
		PlayWaiting();
	}

	function BeginState()
	{
		//StandUp();
		//SetEnemy(None, EnemyLastSeen, true);
		Disable('AnimEnd');
		//SetupWeapon(false);
		//SetDistress(false);
		//bStasis = false;
		SeekPawn = None;
		//EnableCheckDestLoc(false);
	}

	function EndState()
	{
		//EnableCheckDestLoc(false);
		Enable('AnimEnd');
		//bStasis = true;
	}

	Begin:

	if(DXP != none)
	{
		if(bRunningTo == False)
		{
			PlayWalking();
			MoveToward(DXP, 0.120000);
		}
		else
		{
			PlayRunning();
			MoveToward(DXP, 180.000000);
		}

	}
}

defaultproperties
{
}