//=============================================================================
// Follow Player Test
//=============================================================================
class LPFollower extends GenericLP;

Var DeusExPlayer DXP;
var bool bRunningTo;
var int WaitingFor;

function BeginPlay()
{
	SetTimer(1.0, true);

	Super.BeginPlay();
}

function Carcass SpawnCarcass()
{
	if(DXP != None)
	{
		DXP.ClientMessage("|p2One of your followers has been killed.");
	}

	return Super.SpawnCarcass();
}

function Tick(float deltaTime)
{
	if(DXP != None)
	{
		if(DXP.Health < 1)
		{
			DXP = None;
		}
	}

	Super.Tick(deltatime);
}

function Timer()
{
	local vector loc;

	if(DXP == None) //test stuff...
	{
		ChangeAlly('AggPlayer', -1.000000, True);
		ChangeAlly('Player', -1.000000, True);
		//AlliancesEx[5].AllianceName         = 'AggPlayer';
		//AlliancesEx[5].AllianceLevel        = -1.000000;
		//AlliancesEx[5].bPermanent           = True;
		//AlliancesEx[6].AllianceName         = 'Player';
		//AlliancesEx[6].AllianceLevel        = -1.000000;
		//AlliancesEx[6].bPermanent           = True;
	}
	else
	{
		ChangeAlly('AggPlayer', 1.000000, True);
		ChangeAlly('Player', 1.000000, True);
		//AlliancesEx[5].AllianceName         = 'AggPlayer';
		//AlliancesEx[5].AllianceLevel        = 1.000000;
		//AlliancesEx[5].bPermanent           = True;
		//AlliancesEx[6].AllianceName         = 'Player';
		//AlliancesEx[6].AllianceLevel        = 1.000000;
		//AlliancesEx[6].bPermanent           = True;
	}

	if(WaitingFor > 0)
	{
		WaitingFor --;

		if(WaitingFor == 0)
		{
			Orders = 'Wandering';
			gotoState('Wandering');
		}
	}

	if((DXP != None) && (Enemy == None))
	{
		if(VSize(Location-DXP.Location) > 1200)
		{
			loc = DXP.Location;
			loc -= 32.0 * DXP.CollisionRadius * vector(DXP.ViewRotation);
			loc.Z += DXP.CollisionHeight * 0.9;

			SetLocation(loc);
		}
		else if(VSize(Location-DXP.Location) < 200)
		{
			gotoState('Standing');
		}
		else
		{
			GetMoving();
		}
	}
}

function Frob(Actor Frobber, Inventory frobWith) 
{
	if((DXP != DeusExPlayer(Frobber)) && (DeusExPlayer(Frobber).Skin == Texture'DeusExCharacters.Skins.TriadLumPathTex1'))
	{
		if(DXP == None)
		{
			DeusExPlayer(Frobber).ClientMessage("|p3Luminous Path Member: Lead the way.");
			DXP = DeusExPlayer(Frobber);
			GetMoving();
			return;
		}
		else
		{
			DeusExPlayer(Frobber).ClientMessage("|p3Luminous Path Member: I'm currently taking orders from "$DXP.PlayerReplicationInfo.PlayerName$".");
		}
	}

	if(DXP == DeusExPlayer(Frobber)) //move!
	{
		DXP.ClientMessage("|p3Luminous Path Member: Okay. I'll wait here for a while."); //40 seconds for now
		WaitingFor = 40;
		DXP = None;
		gotoState('Standing');
		Orders='Standing';
	}
}

function GetMoving()
{
	if(DXP != None)
	{
		if(VSize(Location-DXP.Location) > 300)
		{
			bRunningTo = True;
			gotoState('Follow');
		}
		else if(VSize(Location-DXP.Location) > 200)
		{
			bRunningTo = False;
			gotoState('Follow');
		}
		else
		{
			gotoState('Standing');
		}
	}
}

State Follow
{
	function SetFall()
	{
		StartFalling('Patrolling', 'ContinuePatrol');
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		Global.HitWall(HitNormal, Wall);
		CheckOpenDoor(HitNormal, Wall);
	}
	
	function AnimEnd()
	{
		PlayWaiting();
	}

	function BeginState()
	{
		//StandUp();
		//SetEnemy(None, EnemyLastSeen, true);
		Disable('AnimEnd');
		//SetupWeapon(false);
		//SetDistress(false);
		//bStasis = false;
		SeekPawn = None;
		//EnableCheckDestLoc(false);
	}

	function EndState()
	{
		//EnableCheckDestLoc(false);
		Enable('AnimEnd');
		//bStasis = true;
	}

	Begin:

	if(DXP != none)
	{
		if(bRunningTo == False)
		{
			PlayWalking();
			MoveToward(DXP, 0.120000);
		}
		else
		{
			PlayRunning();
			MoveToward(DXP, 180.000000);
		}

	}
}

defaultproperties
{
     bRespawning=true
}