//=============================================================================
//
//=============================================================================
class NewScriptedPawnWeapon extends DeusExWeapon
  abstract;

simulated function bool ClientFire( float value ) //Cozmo: Copied and edited from DeusExWeapon in an attempt to cut down on the accessed nones
{						  //hmm ... doesn't seem to be working :/
	local bool bWaitOnAnim;			  //EDIT: Actually, there does seem to be some success with this - keeping it in.
	local vector shake;

	// check for surrounding environment
	if ((EnviroEffective == ENVEFF_Air) || (EnviroEffective == ENVEFF_Vacuum) || (EnviroEffective == ENVEFF_AirVacuum))
	{
		if (Region.Zone.bWaterZone)
		{
			if (Pawn(Owner) != None)
			{
				Pawn(Owner).ClientMessage(msgNotWorking);
				if (!bHandToHand)
					PlaySimSound( Misc1Sound, SLOT_None, TransientSoundVolume * 2.0, 1024 );
			}
			return false;
		}
	}

	if ( !bLooping ) // Wait on animations when not looping
	{
		bWaitOnAnim = ( IsAnimating() && ((AnimSequence == 'Select') || (AnimSequence == 'Shoot') || (AnimSequence == 'ReloadBegin') || (AnimSequence == 'Reload') || (AnimSequence == 'ReloadEnd') || (AnimSequence == 'Down')));
	}
	else
	{
		bWaitOnAnim = False;
		bLooping = False;
	}

	if(Owner.IsA('DeusExPlayer'))
	{
		if ((DeusExPlayer(Owner).NintendoImmunityTimeLeft > 0.01) || (!bClientReadyToFire) || bInProcess || bWaitOnAnim )
		{
			DeusExPlayer(Owner).bJustFired = False;
			bPointing = False;
			bFiring = False;
			return false;
		}
	}

	if ( !Self.IsA('WeaponFlamethrower') )
		ServerForceFire();

	if (bHandToHand)
	{
		SimAmmoAmount = AmmoType.AmmoAmount - 1;

		bClientReadyToFire = False;
		bInProcess = True;
		GotoState('ClientFiring');
		bPointing = True;
		PlaySelectiveFiring();
		PlayFiringSound();

		if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner) != None )
			{
				PlayerPawn(Owner).PlayFiring();
			}
		}
	}
	else if ((ClipCount < ReloadCount) || (ReloadCount == 0))
	{
		if ((ReloadCount == 0) || (AmmoType.AmmoAmount > 0))
		{
			SimClipCount = ClipCount + 1;

			if ( AmmoType != None )
				AmmoType.SimUseAmmo();

			bFiring = True;
			bPointing = True;
			bClientReadyToFire = False;
			bInProcess = True;
			GotoState('ClientFiring');
			if(Owner.IsA('PlayerPawn'))
			{
				if ( PlayerPawn(Owner) != None )
				{
					shake.X = 0.0;
					shake.Y = 100.0 * (ShakeTime*0.5);
					shake.Z = 100.0 * -(currentAccuracy * ShakeVert);
					PlayerPawn(Owner).ClientShake( shake );
					PlayerPawn(Owner).PlayFiring();
				}
			}
			// Don't play firing anim for 20mm
			if ( Ammo20mm(AmmoType) == None )
				PlaySelectiveFiring();
			PlayFiringSound();

			if ( bInstantHit &&  ( Ammo20mm(AmmoType) == None ))
				TraceFire(currentAccuracy);
			else
			{
				if ( !bFlameOn && Self.IsA('WeaponFlamethrower'))
				{
					bFlameOn = True;
					StartFlame();
				}
				ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
			}
		}
		else
		{
			if ( Owner.IsA('DeusExPlayer'))
			{
				if(DeusExPlayer(Owner).bAutoReload == True)
				{
					if ( MustReload() && CanReload() )
					{
						bClientReadyToFire = False;
						bInProcess = False;
						if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
							CycleAmmo();

						ReloadAmmo();
					}
				}
			}
			PlaySimSound( Misc1Sound, SLOT_None, TransientSoundVolume * 2.0, 1024 );		// play dry fire sound
		}
	}
	else
	{
		if ( Owner.IsA('DeusExPlayer'))
		{
			if(DeusExPlayer(Owner).bAutoReload == True)
			{
				if ( MustReload() && CanReload() )
				{
					bClientReadyToFire = False;
					bInProcess = False;
					if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();
					ReloadAmmo();
				}
			}
		}
		PlaySimSound( Misc1Sound, SLOT_None, TransientSoundVolume * 2.0, 1024 );		// play dry fire sound
	}
	return true;
}

defaultproperties
{
}
