﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Weapon : Item {
	public Animator animator;

	public override void PrimaryFire() {
		animator.SetTrigger("swing");
	}

	public override void Reload() { }

	public override void SecondaryFire() { }

	public override void SetExistence(ExistenceMode mode) {
		switch (mode) {
			case ExistenceMode.World:
				animator.enabled = false;
				animator.transform.localPosition = Vector3.zero;
				animator.transform.localRotation = Quaternion.identity;
				break;
			case ExistenceMode.PlayerHand:
				animator.enabled = true;
				break;
		}
		base.SetExistence(mode);
	}
}