﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Events;
using UnityEngine.UI;

public class Keypad : MonoBehaviour {
	public static Keypad instance;
	public string pw = "0451";
	public Text display;
	private string cur;
	public AudioSource source;
	public AudioClip[] btnSfx;
	public AudioClip grantedSfx;
	public AudioClip deniedSfx;
	private CanvasGroup group;
	const char star = '■';
	private float resetTime;
	public UnityEvent onGranted;

	void Awake() {
		instance = this;
		group = GetComponent<CanvasGroup>();
	}

	void Start() {
		Close();
		resetTime = -1;
		cur = "";
		string s = "";
		for (int i = 0; i < pw.Length; i++) {
			s += star;
		}
		display.text = s;
	}

	public void Open() {
		PlayerController.instance.enabled = false;
		CursorManager.AddUser(this);
		group.alpha = 1;
		enabled = true;
	}

	public void Close() {
		PlayerController.instance.enabled = true;
		CursorManager.RemoveUser(this);
		group.alpha = 0;
		enabled = false;
	}

	// Update is called once per frame
	void Update() {
		if (resetTime > 0 && resetTime < Time.time) Start();

		if (Input.GetKeyDown(KeyCode.Alpha0) || Input.GetKeyDown(KeyCode.Keypad0)) OnPressBtn("0");
		else if (Input.GetKeyDown(KeyCode.Alpha1) || Input.GetKeyDown(KeyCode.Keypad1)) OnPressBtn("1");
		else if (Input.GetKeyDown(KeyCode.Alpha2) || Input.GetKeyDown(KeyCode.Keypad2)) OnPressBtn("2");
		else if (Input.GetKeyDown(KeyCode.Alpha3) || Input.GetKeyDown(KeyCode.Keypad3)) OnPressBtn("3");
		else if (Input.GetKeyDown(KeyCode.Alpha4) || Input.GetKeyDown(KeyCode.Keypad4)) OnPressBtn("4");
		else if (Input.GetKeyDown(KeyCode.Alpha5) || Input.GetKeyDown(KeyCode.Keypad5)) OnPressBtn("5");
		else if (Input.GetKeyDown(KeyCode.Alpha6) || Input.GetKeyDown(KeyCode.Keypad6)) OnPressBtn("6");
		else if (Input.GetKeyDown(KeyCode.Alpha7) || Input.GetKeyDown(KeyCode.Keypad7)) OnPressBtn("7");
		else if (Input.GetKeyDown(KeyCode.Alpha8) || Input.GetKeyDown(KeyCode.Keypad8)) OnPressBtn("8");
		else if (Input.GetKeyDown(KeyCode.Alpha9) || Input.GetKeyDown(KeyCode.Keypad9)) OnPressBtn("9");
	}

	public void OnPressBtn(string symbol) {
		cur += symbol;

		if (cur.Length >= pw.Length) {
			if (cur == pw) {
				display.text = "<color=#" + ColorUtility.ToHtmlStringRGB(Color.green) + ">■■GRANTED■■</color>";
				source.PlayOneShot(grantedSfx);
				resetTime = Time.time + 1.5f;
				onGranted.Invoke();
			} else {
				display.text = "<color=#" + ColorUtility.ToHtmlStringRGB(Color.red) + ">■■DENIED■■</color>";
				source.PlayOneShot(deniedSfx);
				resetTime = Time.time + 1.5f;
			}
		} else {
			switch (symbol) {
				case "1":
					source.PlayOneShot(btnSfx[0]);
					break;
				case "2":
					source.PlayOneShot(btnSfx[1]);
					break;
				case "3":
					source.PlayOneShot(btnSfx[2]);
					break;
				case "4":
					source.PlayOneShot(btnSfx[3]);
					break;
				case "5":
					source.PlayOneShot(btnSfx[4]);
					break;
				case "6":
					source.PlayOneShot(btnSfx[5]);
					break;
				case "7":
					source.PlayOneShot(btnSfx[6]);
					break;
				case "8":
					source.PlayOneShot(btnSfx[7]);
					break;
				case "9":
					source.PlayOneShot(btnSfx[8]);
					break;
				case "*":
					source.PlayOneShot(btnSfx[9]);
					break;
				case "0":
					source.PlayOneShot(btnSfx[10]);
					break;
				case "#":
					source.PlayOneShot(btnSfx[11]);
					break;
			}

			string s = "<color=#" + ColorUtility.ToHtmlStringRGB(Color.white) + ">";
			for (int i = 0; i < pw.Length; i++) {
				if (cur.Length == i) s += "</color>";
				s += star;
			}
			display.text = s;
		}
	}
}