﻿using System;
using XNode;

namespace NPCScript {
	[RequireNode(typeof(NPCStartNode))]
	public class NPCGraph : NodeGraph {
		[NonSerialized] public NPC npc;

		public void Begin() {
			(nodes.Find(x => x is NPCStartNode) as NPCStartNode).Enter();
		}

		public void Update() {
			foreach (Node node in nodes) {
				if (node is NPCFlowNode flowNode) flowNode.Update();
			}
		}
	}
}