﻿using UnityEngine;
using XNode;

namespace NPCScript {
	[RequireComponent(typeof(NPC))]
	public class NPCScript : SceneGraph<NPCGraph> {
		public NPC npc { get { return _npc != null ? _npc : _npc = GetComponent<NPC>(); } }
		private NPC _npc;
		public bool beginOnLoad;

		private void Start() {
			if (beginOnLoad) Begin();
		}

		private void Update() {
			graph.npc = npc;
			graph.Update();
		}

		public void Begin() {
			Debug.Log("Begin");
			
			graph.npc = npc;
			graph.Begin();
		}
	}
}