﻿using UnityEngine;

namespace NPCScript {
	[DisallowMultipleNodes]
	public class NPCFollowNode : NPCFlowNode {
		[Input(backingValue = ShowBackingValue.Never)] public bool continueCondition;

		public Transform target;

		public override void OnEnter() { }

		public override void Update() {
			if (!active) return;
			bool condition = GetInputValue("continueCondition", false);
			if (condition) {
				graph.npc.agent.isStopped = true;
				MoveNext("next");
			} else graph.npc.agent.SetDestination(target.position);
		}
	}
}