﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerInteract : MonoBehaviour {
	public static Collider highlight;
	public static Interactable currentInteractable;
	private Material tempMat;
	public static Camera cam;
	void Start() {
		cam = GetComponentInChildren<Camera>();
	}

	void LateUpdate() {
		if (Liftable.carriedPickup != null) {
			Liftable.carriedPickup.transform.position = transform.position + (transform.forward) + (Vector3.up * 0.5f);
			Liftable.carriedPickup.transform.rotation = transform.rotation;
			if (Input.GetKeyDown(KeyCode.E) || Input.GetMouseButtonDown(0)) {
				Liftable.carriedPickup.Throw();
			}
		} else {
			RaycastHit hit;
			highlight = null;
			if (Physics.Raycast(cam.transform.position, cam.transform.forward, out hit, 3)) {
				currentInteractable = hit.collider.GetComponentInParent<Interactable>();
				if (currentInteractable != null) {
					highlight = hit.collider;
					if (Input.GetKeyDown(KeyCode.E)) {
						if (currentInteractable != null) currentInteractable.Interact(true);
					}
				}
			}
		}
	}
}