﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[Serializable]
public class PlayerInventory {
	public List<Item> items = new List<Item>();
	public static readonly Vector2Int size = new Vector2Int(5, 6);

	/// <summary> Add item at automatic position in inventory if it fits </summary>
	public bool AddItem(Item item) {
		for (int y = 0; y < size.x; y++) {
			for (int x = 0; x < size.y; x++) {
				item.shape.position = new Vector2Int(x, y);
				if (!IsSpaceOccupied(item.shape) && !IsOutsideBounds(item.shape)) {
					items.Add(item);
					item.gameObject.SetActive(false);
					return true;
				}
			}
		}
		return false;
	}

	/// <summary> Return true if given rect is outside inventory bounds </summary>
	public bool IsOutsideBounds(RectInt rect) {
		RectInt inventoryRect = new RectInt(Vector2Int.zero, size + Vector2Int.one);
		return !inventoryRect.Contains(rect.min) || !inventoryRect.Contains(rect.max);
	}

	/// <summary> Return true if another item occupies given rect </summary>
	public bool IsSpaceOccupied(RectInt rect, Item exclude = null) {
		foreach (Item item in items) {
			if (item == exclude) continue;
			if (rect.Overlaps(item.shape)) return true;
		}
		return false;
	}

	public void DropItem(Item item) {
		if (item == null) Debug.LogWarning("No item to drop");

		if (Player.instance.hand.heldItem == item) Player.instance.hand.Equip(null);
		Player.instance.hotbar.RemoveItem(item);

		items.Remove(item);
		item.SetExistence(Item.ExistenceMode.World);
		item.transform.position = Player.instance.camera.transform.TransformPoint(Vector3.forward);
		item.rigidbody.velocity = Player.instance.camera.transform.forward * 2;
	}
}