﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerStepper : MonoBehaviour {
	public CharacterController characterController;
	public AudioSource source;
	public float stepDist;

	public AudioClip[] defaultStep;
	public AudioClip[] grassStep;
	private float curDist;
	private Vector3 lastPos;
	private bool inAir;

	void Update() {
		if (characterController.isGrounded) {
			if (inAir) {
				Step();
				inAir = false;
			}
			curDist += Vector3.Distance(lastPos, transform.position);
			lastPos = transform.position;
			if (curDist >= stepDist) {
				Step();
			}
		} else {
			inAir = true;
		}
	}

	void Step() {
		RaycastHit hit;
		if (Physics.Raycast(transform.position, Vector3.down, out hit)) {
			if (hit.collider.material.name.StartsWith("Grass")) source.PlayOneShot(grassStep[Random.Range(0, grassStep.Length)]);
			else source.PlayOneShot(defaultStep[Random.Range(0, defaultStep.Length)]);
		}
		curDist = 0;
	}
}