﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class UIHighlight : MonoBehaviour {
	public Image sprite;
	public Text label;
	public CanvasGroup group;

	private void LateUpdate() {
		if (PlayerInteract.highlight != null) {
			group.alpha = 1;
			RectTransform rt = sprite.transform as RectTransform;

			Vector2 center = PlayerInteract.cam.WorldToScreenPoint(PlayerInteract.highlight.transform.position);
			Vector3 max = PlayerInteract.highlight.bounds.max;
			Vector3 min = PlayerInteract.highlight.bounds.min;

			Vector2 leftTopFront = PlayerInteract.cam.WorldToScreenPoint(new Vector3(max.x, max.y, max.z));
			Vector2 rightTopFront = PlayerInteract.cam.WorldToScreenPoint(new Vector3(min.x, max.y, max.z));
			Vector2 leftBtmFront = PlayerInteract.cam.WorldToScreenPoint(new Vector3(max.x, min.y, max.z));
			Vector2 rightBtmFront = PlayerInteract.cam.WorldToScreenPoint(new Vector3(min.x, min.y, max.z));
			Vector2 leftTopBack = PlayerInteract.cam.WorldToScreenPoint(new Vector3(max.x, max.y, min.z));
			Vector2 rightTopBack = PlayerInteract.cam.WorldToScreenPoint(new Vector3(min.x, max.y, min.z));
			Vector2 leftBtmBack = PlayerInteract.cam.WorldToScreenPoint(new Vector3(max.x, min.y, min.z));
			Vector2 rightBtmBack = PlayerInteract.cam.WorldToScreenPoint(new Vector3(min.x, min.y, min.z));

			Vector2 aabbMin, aabbMax;
			AABB(out aabbMin, out aabbMax, leftTopFront, rightTopFront, leftBtmFront, rightBtmFront, leftTopBack, rightTopBack, leftBtmBack, rightBtmBack);
			sprite.transform.position = (aabbMin + aabbMax) * 0.5f;
			rt.sizeDelta = aabbMax - aabbMin;
			label.text = PlayerInteract.currentInteractable.Title;
		} else {
			group.alpha = 0;
		}
	}

	void AABB(out Vector2 aabbMin, out Vector2 aabbMax, params Vector2[] points) {
		aabbMin = points[0];
		aabbMax = points[0];
		for (int i = 1; i < points.Length; i++) {
			if (points[i].x < aabbMin.x) aabbMin.x = points[i].x;
			if (points[i].y < aabbMin.y) aabbMin.y = points[i].y;
			if (points[i].x > aabbMax.x) aabbMax.x = points[i].x;
			if (points[i].y > aabbMax.y) aabbMax.y = points[i].y;
		}
	}
}