﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class UIHotbar : MonoBehaviour {
	public static UIHotbar instance;

	public UIHotbarSlot[] slots;

	private void Awake() {
		instance = this;
	}

	private void Start() {
		Player.instance.hotbar.onSelectionChange -= UpdateHighlight;
		Player.instance.hotbar.onSelectionChange += UpdateHighlight;
		Player.instance.hotbar.onItemsChange -= UpdateIcons;
		Player.instance.hotbar.onItemsChange += UpdateIcons;

		UpdateHighlight();
		UpdateIcons();
	}

	private void UpdateHighlight() {
		for (int i = 0; i < slots.Length; i++) {
			slots[i].highlight.enabled = i == Player.instance.hotbar.selectedSlot;
		}
	}

	private void UpdateIcons() {
		for (int i = 0; i < slots.Length; i++) {
			Item item = Player.instance.hotbar.GetItem(i);
			if (item != null) {
				slots[i].itemIcon.enabled = true;
				slots[i].itemIcon.sprite = item.icon;
			} else {
				slots[i].itemIcon.enabled = false;
			}
		}
	}
}