﻿using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.UI;

public class UIInventoryItem : MonoBehaviour, IBeginDragHandler, IDragHandler, IEndDragHandler {
	public RectTransform rectTransform { get { return _rectTransform != null ? _rectTransform : _rectTransform = GetComponent<RectTransform>(); } }
	private RectTransform _rectTransform;
	public Image icon;
	public Item item;

	private Vector2 offset;
	private Vector2Int prevPos;

	public void OnBeginDrag(PointerEventData eventData) {
		icon.color = new Color(1, 1, 1, 0.5f);
		prevPos = item.shape.position;
		offset = transform.position - Input.mousePosition;
		icon.raycastTarget = false;
	}

	public void OnDrag(PointerEventData eventData) {
		transform.position = eventData.position + offset;
	}

	public void OnEndDrag(PointerEventData eventData) {
		icon.color = Color.white;

		// Get nearest cell
		Vector2 cellSize = UIInventory.instance.inventoryContainer.rect.size / PlayerInventory.size;
		Vector2Int gridPos = new Vector2Int(
			Mathf.RoundToInt(rectTransform.anchoredPosition.x / cellSize.x), -Mathf.RoundToInt(rectTransform.anchoredPosition.y / cellSize.y)
		);

		if (eventData.used) {
			// Revert to previous position
			rectTransform.anchoredPosition = (prevPos * new Vector2Int(1, -1)) * cellSize;
		} else if (Player.instance.inventory.IsOutsideBounds(new RectInt(gridPos, item.shape.size))) {
			// Drop item
			Player.instance.inventory.DropItem(item);
			Destroy(gameObject);
		} else if (Player.instance.inventory.IsSpaceOccupied(new RectInt(gridPos, item.shape.size), item)) {
			// Revert to previous position
			rectTransform.anchoredPosition = (prevPos * new Vector2Int(1, -1)) * cellSize;
		} else {
			// Snap to new position
			item.shape.position = gridPos;
			rectTransform.anchoredPosition = (gridPos * new Vector2Int(1, -1)) * cellSize;
		}
		icon.raycastTarget = true;

	}
}