﻿using UnityEngine;

[DisallowMultipleComponent]
public abstract class UIWindow : MonoBehaviour {
	public static UIWindow current;

	public bool open { get { return current == this; } }

	protected virtual void Start() {
		gameObject.SetActive(false);
		transform.parent.gameObject.SetActive(false);
	}

	public virtual void Toggle() {
		if (open) Close();
		else Open();
	}

	public void Open() {
		// Already open
		if (open) return;

		if (current != null) current.Close();
		gameObject.SetActive(true);
		transform.parent.gameObject.SetActive(true);
		current = this;
		CursorManager.AddUser(this);
		OnOpen();
	}

	protected abstract void OnOpen();

	public void Close() {
		// Already closed
		if (!open) return;

		gameObject.SetActive(false);
		transform.parent.gameObject.SetActive(false);
		current = null;
		CursorManager.RemoveUser(this);
		OnClose();
	}

	protected abstract void OnClose();
}