﻿using System;
using System.Collections.Generic;
using UnityEngine;

[Serializable]
public class Template<T> where T : MonoBehaviour {
	public T template;
	public readonly List<T> items = new List<T>();
	public readonly Stack<T> pool = new Stack<T>();
	public bool pooled { get; private set; }

	public void Initialize(bool pooled = true) {
		this.pooled = pooled;
		template.gameObject.SetActive(false);
	}

	public void Clear() {
		foreach (T item in items) {
			item.gameObject.SetActive(false);
			if (!pooled) GameObject.Destroy(item.gameObject);
			else pool.Push(item);
		}
		items.Clear();
	}

	public T InstantiateTemplate() {
		T obj;
		if (pool.Count > 0) obj = pool.Pop();
		else obj = GameObject.Instantiate(template);
		Transform t = obj.transform;
		t.SetParent(template.transform.parent);
		t.localPosition = Vector3.zero;
		t.localScale = Vector3.one;
		t.localRotation = Quaternion.identity;
		t.SetAsLastSibling();
		obj.gameObject.SetActive(true);
		items.Add(obj);
		return obj;
	}
}