sampler2D _ParallaxMap;
float _Parallax;
int _Steps;
float _StepDist;



//Get the height from a uv position
float getHeight(float2 texturePos, sampler2D parallaxMap, float parallax)
{
	texturePos = texturePos;

	//Multiply with 0.2 to make the landscape flatter
	float4 colorNoise = tex2Dlod(parallaxMap, float4(texturePos, 0, 0));

	//Calculate the height at this uv coordinate
	//Just use r because r = g = b  because color is grayscale
	//(1-color.r) because black should be low
	//-1 because the ray is going down so the ray's y-coordinate will be negative
	float height = (1 - colorNoise.r) * -1 * parallax;

	return height;
}

//Get the texture position by interpolation between the position where we hit terrain and the position before
float2 getWeightedTexPos(float3 rayPos, float3 rayDir, float stepDistance, sampler2D parallaxMap, float parallax)
{
	//Move one step back to the position before we hit terrain
	float3 oldPos = rayPos - stepDistance * rayDir;

	float oldHeight = getHeight(oldPos.xz, parallaxMap, parallax);

	//Always positive
	float oldDistToTerrain = abs(oldHeight - oldPos.y);

	float currentHeight = getHeight(rayPos.xz, parallaxMap, parallax);

	//Always negative
	float currentDistToTerrain = rayPos.y - currentHeight;

	float weight = currentDistToTerrain / (currentDistToTerrain - oldDistToTerrain);

	//Calculate a weighted texture coordinate
	//If height is -2 and oldHeight is 2, then weightedTex is 0.5, which is good because we should use 
	//the exact middle between the coordinates
	float2 weightedTexPos = oldPos.xz * weight + rayPos.xz * (1 - weight);

	return weightedTexPos;
}

//Find where the ray is intersecting with the terrain with a raymarch algorithm
float2 raymarchUv(float3 tangentViewDir, float2 uv, sampler2D parallaxMap, float parallax) {
	//Where is the ray starting? y is up and we always start at the surface
	float3 rayPos = float3(uv.x, 0, uv.y);

	//What's the direction of the ray?
	float3 rayDir = normalize(tangentViewDir);

	//Find where the ray is intersecting with the terrain with a raymarch algorithm
	for (int i = 0; i < _Steps; i++)
	{
		//Get the current height at this uv coordinate
		float height = getHeight(rayPos.xz, parallaxMap, parallax);

		//If the ray is below the surface
		if (rayPos.y < height)
		{
			//Get the texture position by interpolation between the position where we hit terrain and the position before
			return getWeightedTexPos(rayPos, rayDir, _StepDist, parallaxMap, parallax);
		}

		//Move along the ray
		rayPos += _StepDist * rayDir;
	}
	return uv;
}