﻿using System.Collections;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using XNode;

namespace DialogueSystem {
	[CreateAssetMenu(menuName = "Dialogue/Graph", order = 0)]
	public class DialogueGraph : NodeGraph {
		[HideInInspector]
		public ChatNode current;

		public void Restart() {
			//Find the first DialogueNode without any inputs. This is the starting node.
			current = nodes.Find(x => x is ChatNode && x.Inputs.All(y => !y.IsConnected)) as ChatNode;
		}

		public ChatNode AnswerQuestion(int i) {
			current.AnswerQuestion(i);
			return current;
		}
	}
}