﻿using System.Collections.Generic;
using System.Linq;
using DialogueSystem;
using UnityEditor;
using UnityEngine;
using XNodeEditor;

namespace DialogueEditor {
	[CustomNodeEditor(typeof(SetFlagNode))]
	public class SetFlagNodeEditor : NodeEditor {

		public override void OnBodyGUI() {
			serializedObject.Update();

			SetFlagNode node = target as SetFlagNode;
			NodeEditorGUILayout.PortField(target.GetInputPort("input"), GUILayout.Width(100));
			EditorGUILayout.Space();
			NodeEditorGUILayout.PropertyField(serializedObject.FindProperty("trigger"));

			serializedObject.ApplyModifiedProperties();
		}

		public override int GetWidth() {
			return 336;
		}
	}
}