﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

public class Consumable : Item {
	public int maxStack = 10;

	[NonSerialized] public int count;

	public override void PrimaryFire() {
		Debug.Log("Consume");
		count--;
		if (count <= 0) Destroy(gameObject);
	}

	public override void Reload() { }

	public override void SecondaryFire() { }

	protected override void OnValidate() {
		base.OnValidate();
		maxStack = Mathf.Max(maxStack, 1);
	}
}
