﻿using System.Collections;
using UnityEngine;

public class Door : Interactable {
	public override string Title { get { return "Door"; } }

	public bool locked;
	AnimationCurve curve = AnimationCurve.EaseInOut(0, 0, 1, 1);
	public float angle;
	public float time;
	Vector3 startrot;
	public AudioSource audio;
	bool open;

	void Start() {
		startrot = transform.rotation.eulerAngles;
	}

	public void Toggle() {
		if (open) StartCoroutine(RunClose());
		else StartCoroutine(RunOpen());
		if (audio != null) audio.Play();
	}

	IEnumerator RunOpen() {
		for (float t = 0; t < 1; t += Time.deltaTime / time) {
			transform.rotation = Quaternion.Euler(startrot + new Vector3(0, 0, curve.Evaluate(t) * angle));
			yield return null;
		}
		transform.rotation = Quaternion.Euler(startrot + new Vector3(0, 0, angle));
		open = true;
	}

	IEnumerator RunClose() {
		for (float t = 1; t > 0; t -= Time.deltaTime / time) {
			transform.rotation = Quaternion.Euler(startrot + new Vector3(0, 0, curve.Evaluate(t) * angle));
			yield return null;
		}
		transform.rotation = Quaternion.Euler(startrot);
		open = false;
	}

	public override void Interact(bool player) {
		// Always respond to non-player interactions
		if (!player) Toggle();
		// Deny player access to locked doors
		else if (!locked) Toggle();
	}
}